sampler t0=sampler_state{Texture=(Tex0);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};

float2 reso;
float time;
float4 cursor;
float4 oct;
float ratio;

struct vs2ps{float4 op: POSITION0;float4 np: TEXCOORD0;};
vs2ps VS0(float4 In : POSITION0){vs2ps Out;Out.op = Out.np = sign(In);Out.np*=float4(1.0,-1.0,1.0,1.0);return Out;}

float4 PS0(float4 np: TEXCOORD0): COLOR0 {
	float2 xy=np.xy*0.5+0.5+0.5/reso;
	float2 aspect=float2(ratio,1.0);
	float4 col=0.0;
	float2 w=0.1*oct.xy/aspect;
	for (float i=0.0;i<1.0;i+=1.0/9.0)
	{
		float2 bxy=(xy-cursor.xy)*(1.0-(i-cursor.z)*oct.z)+cursor.xy+w*(i-0.5);
		col+=smoothstep(0.5,0.0,abs(i-0.5))*tex2D(t0,bxy);
	}
	col*=2.0/9.0;
	return col;
}

technique t
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS0();
		PixelShader  = compile ps_2_0 PS0();
	}
}
