#version 120

uniform sampler2D texture;

uniform vec2 screen;
uniform vec2 pixelSize;
uniform float intensity;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(){
	vec2 uv = gl_TexCoord[0].xy-vec2(0.5, 0.5);
	vec2 cc = vec2(0.0, 0.0);
	
	vec4 tc =  texture2D(texture, uv+vec2(0.5, 0.5));
	
	if(intensity > 0.0)
	{
		vec2 d = (1.0 / screen) * intensity * pixelSize;
		vec2 p = d / 2.0;
		cc = vec2(
			d.x * floor((uv.x+p.x) / d.x),
			d.y * floor((uv.y+p.y) / d.y)
		);
		
		tc = texture2D(texture, cc+vec2(0.5, 0.5));
	}
	
	gl_FragColor = tc;
}