#version 110

uniform sampler2D texture;
uniform float phase; // Phase from 0.0 to 1.0
uniform vec2 screen;

void main()
{
	vec4 c = texture2D(texture, gl_FragCoord.xy / screen);
	vec4 c1 = texture2D(texture, (gl_FragCoord.xy + vec2(2, 2)) / screen);
	vec4 c2 = texture2D(texture, (gl_FragCoord.xy + vec2(-2, -2)) / screen);
	
	vec4 herpderp = c * 0.61 + c1 * 0.21 + c2 * 0.21;
	
	c = c * (1.0-phase) + herpderp * phase;
	
	gl_FragColor = vec4(c.rgb*(1.0+phase/2.0), c.a);
}

