
layout (location = 0) in vec4 Position;
layout (location = 1) in vec4 Color;
layout (location = 2) in vec4 Normal;
layout (location = 3) in vec4 TexCoord;

uniform mat4 matrices[2];
uniform vec4 lightpos;

out vec4 ShadowCoord;
out vec3 direction;
out vec3 place;
out vec3 norm;
out float sshadow;
out vec4 TexCoord1;

void main()
{
    TexCoord1 =  TexCoord;

    ShadowCoord = Position - vec4(lightpos.xyz, 1.0);

    place = vec3(inverse(matrices[0])*vec4(0.0,0.0,0.0,1.0));

    direction = normalize(Position.xyz-place) * (length(Position.xyz-place)/50.0);

    norm = Normal.xyz;

    sshadow = dot(normalize(vec3(Normal.xyz)),normalize(lightpos.xyz - Position.xyz));

    gl_FrontColor = vec4(1.0, 1.0, 1.0, 1.0)*0.5 + 0.5*vec4(1.0, 1.0, 1.0, 1.0) * max(sshadow ,0.1) * lightpos.w;// * (6.1/(distance(lightpos.xyz,Position.xyz)));

    gl_Position = matrices[1] * matrices[0] * Position;

}
