#version 330
#extension GL_EXT_geometry_shader4 : enable
layout(lines) in;
layout(line_strip) out;
layout(max_vertices = 100) out;

out vec4 Position;
out vec4 Color;
out vec4 Normal;
out vec4 TexCoord;


uniform float timer;
uniform vec3 center;


mat4 rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 roty = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 rotz = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);



void initialize_matrices(float anglex, float angley, float anglez)
{
     rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , cos(anglex)   , -sin(anglex)  , 0.0,
                 0.0            , sin(anglex)   , cos(anglex)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     roty = mat4(cos(angley)    , 0.0           , sin(angley)   , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 -sin(angley)   , 0.0           , cos(angley)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     rotz = mat4(cos(anglez)    , -sin(anglez)  , 0.0           , 0.0,
                 sin(anglez)    , cos(anglez)   , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);
}


void main()
{

    float clength = timer/1000.0;
    vec3 center1 = gl_PositionIn[0].xyz;

    if(center.z==0.0)
    if(distance(center1, center)<clength)
    {

        TexCoord = vec4(0.5, 0.5, 1.0, 0.0);

        vec4 v1;
        vec4 v2;
        vec4 v3;
        vec4 v4;
        vec4 n1;
        vec4 n2;

        vec3 center2 = gl_PositionIn[1].xyz;
        vec3 dir1 = normalize(center2 - center1);
        vec3 dir2 = normalize(cross(dir1, normalize(vec3(1.0, 3.0, 6.0))));
        n1 = vec4(dir2, 0.0);

        if(distance(center2, center)>clength)
            center2 = clength*normalize(center2);


        v1 = vec4(center1 + dir2 * ((clength-distance(center1, center))/clength), 1.0);
        v2 = vec4(center2 + dir2 * ((clength-distance(center2, center))/clength), 1.0);

        initialize_matrices(dir1.x * 6.283185307179586476925286766559/6.0, dir1.y * 6.283185307179586476925286766559/6.0, dir1.z * 6.283185307179586476925286766559/6.0);

        float thing = (clength-distance(center1, center))/clength;
        Color = vec4(1.0+thing*5, 10.0-thing*9.0, 3.0-thing*3.0, 1.0);

        for(int a=0;a<6;a++)
        {
            v3 = v2;
            v4 = v1;
            v1 = rotz * roty * rotx * (v1-vec4(center1, 0.0)) + vec4(center1, 0.0);
            v2 = rotz * roty * rotx * (v2-vec4(center2, 0.0)) + vec4(center2, 0.0);

            n2 = n1;
            n1 = rotz * roty * rotx * n1;

            Normal = n1;
            Position = v1;
            EmitVertex();

            Position = v2;
            EmitVertex();
            EndPrimitive();

            Normal = n2;
            Position = v3;
            EmitVertex();

            Position = v4;
            EmitVertex();
            EndPrimitive();

        }
    }

    EndPrimitive();


}
