
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float4 g_blur_strength;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;


texture g_tDiffuse;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDepth;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};


float g_depth = 1.0;
float g_scaleX = 1.0;
float g_scaleY = 1.0;

float g_weight = 1.0;


bool valueInThr(float v, float thr) {
  if (v<0.0) {
    v = -v;
  }
  if (v<thr) {
    return true;
  }
  return false;
}


PS_OUT ps( VS_OUTPUT In ) {
  PS_OUT o = (PS_OUT)0;
  float3 tcOfs = float3(g_scaleX/g_windowWidth, g_scaleY/g_windowHeight, 0.0);
  float4 result = float4(0.0, 0.0, 0.0, 0.0);
  float4 depthCurrent = tex2D(smDepth, In.vTexcoord); // the original depth
 // discard;
  float4 depthOther;
  float4 depthOther2;
  float weight = 0.01;
  float thr = 0.003;
  depthOther = tex2D(smDepth, In.vTexcoord+tcOfs.xz);
  depthOther2 = tex2D(smDepth, In.vTexcoord-tcOfs.xz);
  if (valueInThr(depthOther2.r-depthCurrent.r, thr)&&valueInThr(depthOther.r-depthCurrent.r, thr)) {
    result.x = g_weight*(tex2D(smDiffuse, In.vTexcoord+tcOfs.xz).r-tex2D(smDiffuse, In.vTexcoord-tcOfs.xz).r);
  } else {
    discard;
  }
  depthOther = tex2D(smDepth, In.vTexcoord+tcOfs.zy);
  depthOther2 = tex2D(smDepth, In.vTexcoord-tcOfs.zy);
  if (valueInThr(depthOther2.r-depthCurrent.r, thr)&&valueInThr(depthOther.r-depthCurrent.r, thr)) {
	  result.y = g_weight*(tex2D(smDiffuse, In.vTexcoord+tcOfs.zy).r-tex2D(smDiffuse, In.vTexcoord-tcOfs.zy).r);
  } else {
    discard;
  }
  result.z = g_depth;
  result.w = 0.0;
  
  result = (normalize(result)+1.0)*0.50;
  result.a = 1.0;
      
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

