


float2 height_func_bump(float2 p) {
   float2 resx = float2(1.0/512.0, 0.0);
   float2 resy = float2(0.0, 1.0/512.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   return result;
}

MRT_OUT ps_deferred_draw_bump( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
 
 
   float4 ort2 = tex2D(smDiffuse, In.vTexcoord)*g_materialDiffuse;
   ort2.xyz *= g_diffuseIntensity;
   o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;
    
  float4 bumpe = 0;
 
  bumpe.xy = height_func_bump(In.vTexcoordHS.xy);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;  
  // o.rt3.z = 0.0;  
  
  return o;
}

technique bump {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}



texture g_texRefl;
sampler smRefl =
sampler_state {
  Texture = <g_texRefl>;
  MipFilter = LINEAR; // ANISOTROPIC
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

float4 g_reflectTcMul;
float g_reflectAmount;
float4 g_reflectTcOfs;

MRT_OUT ps_deferred_draw_reflect( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
 
   float4 ort2 = tex2D(smDiffuse, In.vTexcoord); //*g_materialDiffuse;
   ort2.xyz *= g_diffuseIntensity;
   o.rt2 = ort2;
   
   float2 tkos = (In.vTexcoord-0.5);
   tkos.x *= g_reflectTcMul.x;
   tkos.y *= g_reflectTcMul.y;
   float4 refl = tex2D(smRefl, (tkos+0.5)+g_reflectTcOfs.xy);
   
  
  if (o.rt2.a < 0.005)
    discard;
    
  float4 bumpe = 0;
 
  bumpe.xy = height_func_bump(In.vTexcoordHS.xy);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt2.xyz += refl.xyz*g_reflectAmount;
  
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;  
  // o.rt3.z = 0.0;  
  
  return o;
}

technique reflect {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_reflect( );
    }
}

