


struct VS_OUTPUT_BASIC_EX {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
    float4  vPosOrig : TEXCOORD6;
};



VS_OUTPUT_BASIC_EX vs_deferred_draw_background( const VS_INPUT v ) {
  VS_OUTPUT_BASIC_EX o;
  
  float4 vPosTrans = v.vPosition;
  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  o.vPosOrig = vPosTrans;
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  o.vNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  float2 tc = v.vTexcoord;
  
  tc.y = vPosTrans.y;
  tc.x = (abs(atan(vPosTrans.z / vPosTrans.x)/(3.141592)))*0.5;
  
  o.vTexcoord = tc*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = tc*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = tc*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}



float2 height_func_background(float2 p) {
   float2 resx = float2(1.0/128.0, 0.0);
   float2 resy = float2(0.0, 1.0/128.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   return result;
}


MRT_OUT ps_deferred_draw_background( VS_OUTPUT_BASIC_EX In ) {
  MRT_OUT o=(MRT_OUT)0;

    float2 tc = In.vTexcoord;
    
  tc.y = -In.vPosOrig.y*0.5+0.5;
  tc.x = In.vPosOrig.x*0.5+0.5; // (atan(In.vPosOrig.z / In.vPosOrig.x)/(3.141592)+1.0)*0.5;
    
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;  
  
    
  float4 bumpe = 0;
  bumpe.xy = height_func_background(tc);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = 1.0;  
  
  return o;
}

technique background {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_background( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_background( );
    }
}
