
#version 150 compatibility 
#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_draw_instanced : enable


uniform sampler2D smp_particle ;

in vec4 color ;
in vec2 tex_coord ;

/// The time in [0,1]
in float vf_time ;

float smoothed_pulse( float t )
{
	
	return smoothstep(0.0,0.25,t) - smoothstep(0.75,1.0, t) ;
}

void main()
{
	vec4 tex_color = texture2D(smp_particle, tex_coord) ; 

	//gl_FragColor = vec4(0.3,0.3,0.3,1.0) * vf_time;
	//gl_FragColor = vec4(tex_color.rgb,smoothed_pulse(vf_time)*tex_color.a) ;
	gl_FragData[0] = vec4(vec3(1.0),smoothed_pulse(vf_time)*(1.0-tex_color.r)) ;
	gl_FragDepth = gl_FragCoord.z ;
}