#ifdef GL_ES
precision highp float;
#endif

uniform float time;
uniform float beat;
uniform sampler2D tex0;


void main(void)
{
    vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy ;
    p.x = p.x + sin(time);
    p.y = p.y + cos(time*0.5);
    vec2 uv;
   
    float a = atan(p.y,p.x)*1.0;
    float r = (1.0+beat*0.05)*2.0/sqrt(dot(p,p));

    uv.y = (a+sin(a/0.2+p.x+time*2.0))/6.283185307179586476925286766559;
    uv.x = (sin(a/0.5+p.y+time)*3.0+r+time*3.0)/1.5707963267948966192313216916398;
	

    vec3 col =  ((4.0-r)/2.0)*texture2D(tex0,uv).xyz*abs(a);

    gl_FragColor = vec4(col,1.0);
}
/*


void main(void)
{
	float t = time;
	vec2 p = gl_TexCoord[0].xy;
	
	vec2 p1;
	float r = -t*0.000125;
	float scale1 = sin(t*0.001+p.x)*0.25+1.0;
	
	p1.x = scale1*p.x*cos(r) + scale1*p.y*sin(r);
	p1.y = scale1*p.y*cos(r) - scale1*p.x*sin(r);


	vec2 p2;
	float r2 = t*0.0001;
	p.x = sin(r2)+p.x;
	p.y = sin(r2*0.5)+p.y;

	float scale = sin(t*0.001+p.y+p.x)*0.25+1.0;

	p2.x = scale*p.x*cos(r2) + scale*p.y*sin(r2);
	p2.y = scale*p.y*cos(r2) - scale*p.x*sin(r2);

	gl_FragColor = texture2D(tex0, p2.xy)*texture2D(tex0, p1.xy);
}
*/