float4x4 WVP;
float4x4 WorldView;
struct VSInput
{
	float3 Position: POSITION;
	float3 Normal: NORMAL;
};

struct VSOutput
{
	float4 SV_Position: SV_POSITION;
	float3 Normal: NORMAL;
};

VSOutput vsMain(VSInput input)
{
	VSOutput output;
	output.SV_Position = mul(WVP, float4(input.Position, 1.0));
	output.Normal = mul(WorldView, float4(input.Normal.xyz, 0.0));
	return output;
}

float4 psMain(VSOutput input): SV_TARGET
{
	return float4(normalize(input.Normal) * 0.5 + 0.5, 1.0);
}

