
float4x4 View;
float4x4 Projection;

Texture2D ViewPositionMap;
Texture2D ViewNormalMap;

float2 Resolution;

struct Light
{
	float3 Position: POSITION;
	float4 ColorSize: COLOR_SIZE;
};

Light vsMain(Light Input)
{
	return Input;
}

struct GSOutput
{
	float4 Position: SV_Position;
	float3 PointCoord: POINTCOORD;
	float4 ColorSize: COLOR_SIZE;
};

[maxvertexcount(4)]
void gsMain(in point Light p[1], inout TriangleStream<GSOutput> stream)
{
	float3 viewPosition = mul(View, float4(p[0].Position,1)).xyz;
	
	GSOutput v;
	v.ColorSize = p[0].ColorSize;
	float size = p[0].ColorSize.w * 0.04;
	v.PointCoord = float3(-1,-1,0);
	v.Position = mul(Projection, float4(viewPosition + v.PointCoord*size,1)); stream.Append(v);
	v.PointCoord = float3( 1,-1,0);
	v.Position = mul(Projection, float4(viewPosition + v.PointCoord*size,1)); stream.Append(v);
	v.PointCoord = float3(-1, 1,0);
	v.Position = mul(Projection, float4(viewPosition + v.PointCoord*size,1)); stream.Append(v);
	v.PointCoord = float3( 1, 1,0);
	v.Position = mul(Projection, float4(viewPosition + v.PointCoord*size,1)); stream.Append(v);
	stream.RestartStrip();	
}

float4 psMain(GSOutput Input): SV_Target
{
	float phong = pow(max(0, 1.0 - length(Input.PointCoord.xy)), 2);
	return float4(Input.ColorSize.xyz*phong,1);
}