/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLFramebufferObject;
import codeanticode.glgraphics.GLTexture;
import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGeffect;
import com.sun.opengl.cg.CGprogram;
import com.sun.opengl.cg.CgGL;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import processing.core.PConstants;

public class GLState
implements GLConstants,
PConstants {
    public static boolean multiTexAvailable = true;
    public static boolean vbosAvailable = true;
    public static boolean fbosAvailable = true;
    public static boolean shadersAvailable = true;
    public static boolean geoShadersAvailable = true;
    public static boolean vertShadersAvailable = true;
    public static boolean fragShadersAvailable = true;
    public static boolean glsl100Available = true;
    public static boolean floatTexAvailable = true;
    public static boolean nonTwoPowTexAvailable = true;
    public static boolean fboMultisampleAvailable = true;
    public static GL gl;
    public static GLU glu;
    protected static long INSTANCES_COUNT;
    protected static boolean blendEnabled;
    protected static int blendMode;
    protected static boolean blendEnabled0;
    protected static int blendMode0;
    protected static boolean singleFBO;
    protected static boolean popFramebufferEnabled;
    protected static boolean pushFramebufferEnabled;
    protected static boolean framebufferFixed;
    protected static String glVersion;
    protected static int glMajor;
    protected static int glMinor;
    protected static String glslVersion;
    protected static int glMaxColorAttach;
    protected static GLFramebufferObject FBO;
    protected static GLFramebufferObject currentFBO;
    protected static GLFramebufferObject screenFBO;
    protected static GLTexture[] currentDestTex;
    protected static GLTexture[] emptyDestTex;
    protected static Stack<GLFramebufferObject> fboStack;
    protected static Stack<GLTexture[]> destTexStack;
    protected static Set<Integer> glTextureObjects;
    protected static Set<Integer> glVertexBuffers;
    protected static Set<Integer> glFrameBuffers;
    protected static Set<Integer> glRenderBuffers;
    protected static Set<Integer> glslPrograms;
    protected static Set<Integer> glslShaders;
    protected static Set<Object> cgContexts;
    protected static Set<Object> cgPrograms;
    protected static Set<Object> cgEffects;

    public GLState(GL gL) {
        if (INSTANCES_COUNT == 0L) {
            gl = gL;
            glTextureObjects = new HashSet<Integer>();
            glVertexBuffers = new HashSet<Integer>();
            glFrameBuffers = new HashSet<Integer>();
            glRenderBuffers = new HashSet<Integer>();
            glslPrograms = new HashSet<Integer>();
            glslShaders = new HashSet<Integer>();
            cgContexts = new HashSet<Object>();
            cgPrograms = new HashSet<Object>();
            cgEffects = new HashSet<Object>();
            this.getVersionNumbers();
            this.getAvailableExtensions();
            int[] nArray = new int[]{0};
            gL.glGetIntegerv(36063, nArray, 0);
            glMaxColorAttach = nArray[0];
            glu = new GLU();
            FBO = new GLFramebufferObject(gL);
            fboStack = new Stack();
            destTexStack = new Stack();
            currentFBO = screenFBO = new GLFramebufferObject(gL, true);
            emptyDestTex = new GLTexture[0];
            currentDestTex = emptyDestTex;
            singleFBO = false;
        }
        ++INSTANCES_COUNT;
    }

    public static int createGLResource(int n) {
        return GLState.createGLResource(n, 0);
    }

    public static int createGLResource(int n, int n2) {
        int n3 = 0;
        if (n == 0) {
            int[] nArray = new int[1];
            gl.glGenTextures(1, nArray, 0);
            n3 = nArray[0];
            glTextureObjects.add(n3);
        } else if (n == 1) {
            int[] nArray = new int[1];
            gl.glGenBuffersARB(1, nArray, 0);
            n3 = nArray[0];
            glVertexBuffers.add(n3);
        } else if (n == 2) {
            int[] nArray = new int[1];
            gl.glGenFramebuffersEXT(1, nArray, 0);
            n3 = nArray[0];
            glFrameBuffers.add(n3);
        } else if (n == 3) {
            int[] nArray = new int[1];
            gl.glGenRenderbuffersEXT(1, nArray, 0);
            n3 = nArray[0];
            glRenderBuffers.add(n3);
        } else if (n == 4) {
            n3 = gl.glCreateProgram();
            glslPrograms.add(n3);
        } else if (n == 5) {
            n3 = gl.glCreateShader(n2);
            glslShaders.add(n3);
        }
        return n3;
    }

    public static Object createCGResource(int n) {
        return GLState.createCGResource(n, null, null, 0);
    }

    public static Object createCGResource(int n, CGcontext cGcontext, String string) {
        return GLState.createCGResource(n, cGcontext, string, 0);
    }

    public static Object createCGResource(int n, CGcontext cGcontext, String string, int n2) {
        CGcontext cGcontext2 = null;
        if (n == 6) {
            cGcontext2 = CgGL.cgCreateContext();
            cgContexts.add(cGcontext2);
        } else if (n == 7) {
            cGcontext2 = CgGL.cgCreateProgram((CGcontext)cGcontext, (int)4112, (String)string, (int)n2, null, null);
            cgPrograms.add((CGprogram)cGcontext2);
        } else if (n == 8) {
            cGcontext2 = CgGL.cgCreateEffect((CGcontext)cGcontext, (String)string, null);
            cgEffects.add((CGeffect)cGcontext2);
        }
        return cGcontext2;
    }

    public static void deleteGLResource(int n, int n2) {
        if (n2 == 0) {
            if (glTextureObjects.contains(n)) {
                int[] nArray = new int[]{n};
                gl.glDeleteTextures(1, nArray, 0);
                glTextureObjects.remove(n);
            }
        } else if (n2 == 1) {
            if (glVertexBuffers.contains(n)) {
                int[] nArray = new int[]{n};
                gl.glDeleteBuffersARB(1, nArray, 0);
                glVertexBuffers.remove(n);
            }
        } else if (n2 == 2) {
            if (glFrameBuffers.contains(n)) {
                int[] nArray = new int[]{n};
                gl.glDeleteFramebuffersEXT(1, nArray, 0);
                glFrameBuffers.remove(n);
            }
        } else if (n2 == 3) {
            if (glRenderBuffers.contains(n)) {
                int[] nArray = new int[]{n};
                gl.glDeleteRenderbuffersEXT(1, nArray, 0);
                glRenderBuffers.remove(n);
            }
        } else if (n2 == 4) {
            if (glslPrograms.contains(n)) {
                gl.glDeleteProgram(n);
                glslPrograms.remove(n);
            }
        } else if (n2 == 5 && glslShaders.contains(n)) {
            gl.glDeleteShader(n);
            glslShaders.remove(n);
        }
    }

    public static void deleteCGResource(Object object, int n) {
        if (n == 6) {
            if (cgContexts.contains(object)) {
                CgGL.cgDestroyContext((CGcontext)((CGcontext)object));
                cgContexts.remove(object);
            }
        } else if (n == 7) {
            if (cgPrograms.contains(object)) {
                CgGL.cgDestroyProgram((CGprogram)((CGprogram)object));
                cgPrograms.remove(object);
            }
        } else if (n == 8 && cgEffects.contains(object)) {
            CgGL.cgDestroyEffect((CGeffect)((CGeffect)object));
            cgEffects.remove(object);
        }
    }

    public static void deleteAllGLResources() {
        int[] nArray;
        int n;
        int n2;
        Object[] objectArray;
        if (!glTextureObjects.isEmpty()) {
            objectArray = glTextureObjects.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                gl.glDeleteTextures(1, nArray, 0);
            }
            glTextureObjects.clear();
        }
        if (!glVertexBuffers.isEmpty()) {
            objectArray = glVertexBuffers.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                gl.glDeleteBuffersARB(1, nArray, 0);
            }
            glVertexBuffers.clear();
        }
        if (!glFrameBuffers.isEmpty()) {
            objectArray = glFrameBuffers.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                gl.glDeleteFramebuffersEXT(1, nArray, 0);
            }
            glFrameBuffers.clear();
        }
        if (!glRenderBuffers.isEmpty()) {
            objectArray = glRenderBuffers.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                gl.glDeleteRenderbuffersEXT(1, nArray, 0);
            }
            glRenderBuffers.clear();
        }
        if (!glslPrograms.isEmpty()) {
            objectArray = glslPrograms.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                gl.glDeleteProgram(n);
            }
            glslPrograms.clear();
        }
        if (!glslShaders.isEmpty()) {
            objectArray = glslShaders.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                gl.glDeleteShader(n);
            }
            glslShaders.clear();
        }
        if (!cgContexts.isEmpty()) {
            objectArray = cgContexts.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object = objectArray[n2];
                CgGL.cgDestroyContext((CGcontext)((CGcontext)object));
            }
            cgContexts.clear();
        }
        if (!cgPrograms.isEmpty()) {
            objectArray = cgPrograms.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object = objectArray[n2];
                CgGL.cgDestroyProgram((CGprogram)((CGprogram)object));
            }
            cgPrograms.clear();
        }
        if (!cgEffects.isEmpty()) {
            objectArray = cgEffects.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object = objectArray[n2];
                CgGL.cgDestroyEffect((CGeffect)((CGeffect)object));
            }
            cgEffects.clear();
        }
    }

    public void setOrthographicView(int n, int n2) {
        gl.glViewport(0, 0, n, n2);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0, (double)n, 0.0, (double)n2);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void saveView() {
        gl.glPushAttrib(2048);
        this.saveGLMatrices();
    }

    public void restoreView() {
        this.restoreGLMatrices();
        gl.glPopAttrib();
    }

    public void saveGLState() {
        gl.glPushAttrib(1048575);
        this.saveGLMatrices();
    }

    public void restoreGLState() {
        this.restoreGLMatrices();
        gl.glPopAttrib();
    }

    public void saveGLMatrices() {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
    }

    public void restoreGLMatrices() {
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    public void clearColorBuffer(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        float f = (float)n2 / 255.0f;
        float f2 = (float)n3 / 255.0f;
        float f3 = (float)n4 / 255.0f;
        float f4 = (float)n5 / 255.0f;
        gl.glClearColor(f2, f3, f4, f);
        gl.glClear(16384);
    }

    public void copyTex(GLTexture gLTexture, GLTexture gLTexture2) {
        float f = gLTexture.getMaxTextureCoordS();
        float f2 = gLTexture.getMaxTextureCoordT();
        float f3 = 0.0f;
        float f4 = 1.0f;
        if (gLTexture2.isFlippedX()) {
            f3 = 1.0f;
            f4 = -1.0f;
        }
        float f5 = 0.0f;
        float f6 = 1.0f;
        if (gLTexture2.isFlippedY()) {
            f5 = 1.0f;
            f6 = -1.0f;
        }
        gl.glEnable(gLTexture.getTextureTarget());
        gl.glActiveTexture(33984);
        gl.glBindTexture(gLTexture.getTextureTarget(), gLTexture.getTextureID());
        this.pushFramebuffer();
        this.setFramebuffer(FBO);
        FBO.setDrawBuffer(gLTexture2.getTextureTarget(), gLTexture2.getTextureID());
        this.saveView();
        this.setOrthographicView(gLTexture2.width, gLTexture2.height);
        gl.glEnable(gLTexture.getTextureTarget());
        gl.glActiveTexture(33984);
        gl.glBindTexture(gLTexture.getTextureTarget(), gLTexture.getTextureID());
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f((f3 + f4 * 0.0f) * f, (f5 + f6 * 0.0f) * f2);
        gl.glVertex2f(0.0f, 0.0f);
        gl.glTexCoord2f((f3 + f4 * 1.0f) * f, (f5 + f6 * 0.0f) * f2);
        gl.glVertex2f((float)gLTexture.width, 0.0f);
        gl.glTexCoord2f((f3 + f4 * 1.0f) * f, (f5 + f6 * 1.0f) * f2);
        gl.glVertex2f((float)gLTexture.width, (float)gLTexture.height);
        gl.glTexCoord2f((f3 + f4 * 0.0f) * f, (f5 + f6 * 1.0f) * f2);
        gl.glVertex2f(0.0f, (float)gLTexture.height);
        gl.glEnd();
        gl.glBindTexture(gLTexture.getTextureTarget(), 0);
        this.restoreView();
        this.popFramebuffer();
    }

    public void clearTex(int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        float f = (float)n4 / 255.0f;
        float f2 = (float)n5 / 255.0f;
        float f3 = (float)n6 / 255.0f;
        float f4 = (float)n7 / 255.0f;
        this.pushFramebuffer();
        this.setFramebuffer(FBO);
        FBO.setDrawBuffer(n2, n);
        gl.glClearColor(f2, f3, f4, f);
        gl.glClear(16384);
        this.popFramebuffer();
    }

    public void paintTex(int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 >> 24 & 0xFF;
        int n7 = n5 >> 16 & 0xFF;
        int n8 = n5 >> 8 & 0xFF;
        int n9 = n5 & 0xFF;
        float f = (float)n6 / 255.0f;
        float f2 = (float)n7 / 255.0f;
        float f3 = (float)n8 / 255.0f;
        float f4 = (float)n9 / 255.0f;
        this.pushFramebuffer();
        this.setFramebuffer(FBO);
        FBO.setDrawBuffer(n2, n);
        this.saveView();
        this.setOrthographicView(n3, n4);
        gl.glColor4f(f2, f3, f4, f);
        gl.glBegin(7);
        gl.glVertex2f(0.0f, 0.0f);
        gl.glVertex2f((float)n3, 0.0f);
        gl.glVertex2f((float)n3, (float)n4);
        gl.glVertex2f(0.0f, (float)n4);
        gl.glEnd();
        this.restoreView();
        this.popFramebuffer();
    }

    protected void enableBlend() {
        blendEnabled = true;
        gl.glEnable(3042);
    }

    protected void disableBlend() {
        blendEnabled = false;
        gl.glDisable(3042);
    }

    protected void saveBlendConfig() {
        blendEnabled0 = blendEnabled;
        blendMode0 = blendMode;
    }

    protected void restoreBlendConfig() {
        if (blendEnabled0) {
            this.enableBlend();
        } else {
            this.disableBlend();
        }
        this.setupBlending(blendMode0);
    }

    protected void setupBlending(int n) {
        blendMode = n;
        if (blendMode == 0) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(1, 0);
        } else if (blendMode == 1) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(770, 771);
        } else if (blendMode == 2) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(770, 1);
        } else if (blendMode == 4) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(775, 0);
        } else if (blendMode == 8) {
            gl.glBlendEquation(32776);
            gl.glBlendFunc(770, 772);
        } else if (blendMode == 16) {
            gl.glBlendEquation(32775);
            gl.glBlendFunc(770, 772);
        } else if (blendMode == 32) {
            gl.glBlendEquation(32779);
            gl.glBlendFunc(1, 1);
        } else if (blendMode == 64) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(775, 769);
        } else if (blendMode == 128) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(774, 768);
        } else if (blendMode == 256) {
            gl.glBlendEquation(32774);
            gl.glBlendFunc(775, 1);
        } else if (blendMode == 16384) {
            gl.glBlendColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl.glBlendFunc(1, 32769);
        }
    }

    protected void setupDefaultBlending() {
        blendMode = 1;
        gl.glBlendEquation(32774);
        gl.glBlendFunc(770, 771);
    }

    public static void enableSingleFBO() {
        singleFBO = true;
    }

    public static void disableSingleFBO() {
        singleFBO = false;
    }

    public static boolean isSingleFBO() {
        return singleFBO;
    }

    public static void enablePopFramebuffer() {
        popFramebufferEnabled = true;
    }

    public static void disablePopFramebuffer() {
        popFramebufferEnabled = false;
    }

    public static boolean isPopFramebufferEnabled() {
        return popFramebufferEnabled;
    }

    public static void enablePushFramebuffer() {
        pushFramebufferEnabled = true;
    }

    public static void disablePushFramebuffer() {
        pushFramebufferEnabled = false;
    }

    public static boolean isPushFramebufferEnabled() {
        return pushFramebufferEnabled;
    }

    public static void setFramebufferFixed(boolean bl) {
        framebufferFixed = bl;
    }

    public static boolean isFramebufferFixed() {
        return framebufferFixed;
    }

    public static String getGLVersion() {
        return glVersion;
    }

    public static int getGLMajor() {
        return glMajor;
    }

    public static int getGLMinor() {
        return glMinor;
    }

    public static String getGLSLVersion() {
        return glslVersion;
    }

    protected void pushFramebuffer() {
        if (pushFramebufferEnabled) {
            fboStack.push(currentFBO);
        }
    }

    protected void setFramebuffer(GLFramebufferObject gLFramebufferObject) {
        if (framebufferFixed) {
            return;
        }
        currentFBO = gLFramebufferObject;
        currentFBO.bind();
    }

    protected void popFramebuffer() {
        if (!popFramebufferEnabled) {
            return;
        }
        try {
            currentFBO = fboStack.pop();
            currentFBO.bind();
        }
        catch (EmptyStackException emptyStackException) {
            System.out.println("Empty framebuffer stack");
        }
    }

    protected void pushDestTextures() {
        destTexStack.push(currentDestTex);
    }

    protected void setDestTexture(GLTexture gLTexture) {
        this.setDestTextures(new GLTexture[]{gLTexture}, 1);
    }

    protected void setDestTextures(GLTexture[] gLTextureArray) {
        this.setDestTextures(gLTextureArray, gLTextureArray.length);
    }

    protected void setDestTextures(GLTexture[] gLTextureArray, int n) {
        currentDestTex = gLTextureArray;
        currentFBO.setDrawBuffers(currentDestTex, n);
    }

    protected void popDestTextures() {
        try {
            currentDestTex = destTexStack.pop();
            currentFBO.setDrawBuffers(currentDestTex);
        }
        catch (EmptyStackException emptyStackException) {
            System.out.println("Empty texture stack");
        }
    }

    protected void getVersionNumbers() {
        glVersion = gl.glGetString(7938);
        glMajor = Character.getNumericValue(glVersion.charAt(0));
        glMinor = Character.getNumericValue(glVersion.charAt(2));
        glslVersion = gl.glGetString(35724);
    }

    protected void getAvailableExtensions() {
        String string = gl.glGetString(7939);
        if (string.indexOf("GL_ARB_multitexture") == -1) {
            multiTexAvailable = false;
            System.out.println("GL_ARB_multitexture extension not available");
        }
        if (string.indexOf("GL_ARB_vertex_buffer_object") == -1) {
            vbosAvailable = false;
            System.out.println("GL_ARB_vertex_buffer_object extension not available");
        }
        if (string.indexOf("GL_EXT_framebuffer_object") == -1) {
            fbosAvailable = false;
            System.out.println("GL_EXT_framebuffer_object extension not available");
        }
        if (string.indexOf("GL_ARB_shader_objects") == -1) {
            shadersAvailable = false;
            System.out.println("GL_ARB_shader_objects extension not available");
        }
        if (string.indexOf("GL_EXT_geometry_shader4") == -1) {
            geoShadersAvailable = false;
            System.out.println("GL_ARB_geometry_shader4 extension not available");
        }
        if (string.indexOf("GL_ARB_vertex_shader") == -1) {
            vertShadersAvailable = false;
            System.out.println("GL_ARB_vertex_shader extension not available");
        }
        if (string.indexOf("GL_ARB_fragment_shader") == -1) {
            fragShadersAvailable = false;
            System.out.println("GL_ARB_fragment_shader extension not available");
        }
        if (string.indexOf("GL_ARB_shading_language_100") == -1) {
            glsl100Available = false;
            System.out.println("GL_ARB_shading_language_100 extension not available");
        }
        if (string.indexOf("GL_ARB_texture_float") == -1) {
            floatTexAvailable = false;
            System.out.println("GL_ARB_texture_float extension not available");
        }
        if (string.indexOf("GL_ARB_texture_non_power_of_two") == -1) {
            nonTwoPowTexAvailable = false;
            System.out.println("GL_ARB_texture_non_power_of_two extension not available");
        }
        if (string.indexOf("GL_EXT_framebuffer_multisample") == -1) {
            fboMultisampleAvailable = false;
            System.out.println("GL_EXT_framebuffer_multisample extension not available");
        }
    }

    static {
        INSTANCES_COUNT = 0L;
        blendEnabled = true;
        blendMode = 1;
        popFramebufferEnabled = true;
        pushFramebufferEnabled = true;
        framebufferFixed = false;
    }
}

