/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLModelEffect;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import codeanticode.glgraphics.GLUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLModel
implements PConstants,
GLConstants {
    protected PApplet parent;
    protected GL gl;
    protected PGraphicsOpenGL pgl;
    protected GLState glstate;
    protected int size;
    protected int vertexMode;
    protected int vboUsage;
    protected int[] vertCoordsVBO = new int[]{0};
    protected String description;
    protected float[] tmpVertArray;
    protected float[] tmpColorArray;
    protected float[] tmpNormalsArray;
    protected float[] tmpTexCoordsArray;
    protected float[] tmpAttributesArray;
    protected int[] tmpIndexArray;
    protected int[] colorsVBO = null;
    protected int[] normCoordsVBO = null;
    protected int[] texCoordsVBO = null;
    protected int[] indicesVBO = null;
    protected boolean autoIndexBoundCalc;
    protected float tintR;
    protected float tintG;
    protected float tintB;
    protected float tintA;
    protected float[] specularColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float[] emissiveColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected float[] shininess = new float[]{0.0f};
    protected float pointSize = 1.0f;
    protected float lineWidth = 1.0f;
    protected float maxPointSize;
    protected boolean blend;
    protected int blendMode;
    protected boolean usingPointSprites;
    protected int numAttributes;
    protected int[] attribVBO = null;
    protected String[] attribName;
    protected int[] attribSize;
    protected int curtAttrSize;
    protected int numTextures;
    protected int minIndex;
    protected int maxIndex;
    protected int maxIndicesCount;
    protected int indicesCount;
    public GLTexture[] textures;
    public FloatBuffer vertices;
    public FloatBuffer colors;
    public FloatBuffer normals;
    public FloatBuffer texCoords;
    public FloatBuffer attributes;
    public IntBuffer indices;
    public float width;
    public float height;
    public float depth;
    public float xmin;
    public float xmax;
    public float ymin;
    public float ymax;
    public float zmin;
    public float zmax;
    public static final int STATIC = 0;
    public static final int DYNAMIC = 1;
    public static final int STREAM = 2;
    float maxSpriteSize;
    protected float[] spriteDistAtt = new float[]{1.0f, 0.0f, 0.0f};

    public GLModel(PApplet pApplet, int n, int n2, int n3) {
        this.initModelCommon(pApplet);
        this.size = n;
        if (n2 == 2) {
            this.vertexMode = 0;
        } else if (n2 == 52) {
            this.vertexMode = 0;
            this.usingPointSprites = true;
            float[] fArray = new float[]{0.0f};
            this.gl.glGetFloatv(33063, fArray, 0);
            this.maxSpriteSize = this.maxPointSize = fArray[0];
        } else if (n2 == 4) {
            this.vertexMode = 1;
        } else if (n2 == 50) {
            this.vertexMode = 3;
        } else if (n2 == 51) {
            this.vertexMode = 2;
        } else if (n2 == 9) {
            this.vertexMode = 4;
        } else if (n2 == 11) {
            this.vertexMode = 6;
        } else if (n2 == 10) {
            this.vertexMode = 5;
        } else if (n2 == 16) {
            this.vertexMode = 7;
        } else if (n2 == 17) {
            this.vertexMode = 8;
        } else if (n2 == 20) {
            this.vertexMode = 9;
        }
        if (n3 == 0) {
            this.vboUsage = 35044;
        } else if (n3 == 1) {
            this.vboUsage = 35048;
        } else if (n3 == 2) {
            this.vboUsage = 35042;
        }
        this.vertCoordsVBO[0] = GLState.createGLResource(1);
        this.gl.glBindBufferARB(34962, this.vertCoordsVBO[0]);
        this.gl.glBufferDataARB(34962, this.size * 4 * 4, null, this.vboUsage);
        this.gl.glBindBufferARB(34962, 0);
        this.description = "Just another GLModel";
    }

    public GLModel(PApplet pApplet, float[] fArray, int n, int n2) {
        this(pApplet, fArray.length / 4, n, n2);
        this.updateVertices(fArray);
    }

    public GLModel(PApplet pApplet, ArrayList<PVector> arrayList, int n, int n2) {
        this(pApplet, arrayList.size(), n, n2);
        this.updateVertices(arrayList);
    }

    public GLModel(PApplet pApplet, String string) {
        this.initModelCommon(pApplet);
        this.parent = pApplet;
        string = string.replace('\\', '/');
        XMLElement xMLElement = new XMLElement(pApplet, string);
        this.loadXML(xMLElement);
    }

    public GLModel(PApplet pApplet, URL uRL) {
        this.initModelCommon(pApplet);
        this.parent = pApplet;
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            XMLElement xMLElement = new XMLElement(string);
            this.loadXML(xMLElement);
        }
        catch (IOException iOException) {
            System.err.println("Error loading effect: " + iOException.getMessage());
        }
    }

    public void delete() {
        this.releaseModel();
    }

    public int getMode() {
        return this.vertexMode;
    }

    public int getSize() {
        return this.size;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCoordsVBO() {
        return this.vertCoordsVBO[0];
    }

    public void initNormals() {
        this.normCoordsVBO = new int[1];
        this.normCoordsVBO[0] = GLState.createGLResource(1);
        this.gl.glBindBufferARB(34962, this.normCoordsVBO[0]);
        this.gl.glBufferDataARB(34962, this.size * 4 * 4, null, this.vboUsage);
        this.gl.glBindBufferARB(34962, 0);
    }

    public void initColors() {
        this.colorsVBO = new int[1];
        this.colorsVBO[0] = GLState.createGLResource(1);
        this.gl.glBindBufferARB(34962, this.colorsVBO[0]);
        this.gl.glBufferDataARB(34962, this.size * 4 * 4, null, this.vboUsage);
        this.gl.glBindBufferARB(34962, 0);
    }

    public void initAttributes(int n) {
        this.numAttributes = n;
        this.attribVBO = new int[n];
        this.attribName = new String[n];
        this.attribSize = new int[n];
        for (int i = 0; i < n; ++i) {
            this.attribVBO[i] = GLState.createGLResource(1);
        }
    }

    public void setAttribute(int n, String string, int n2) {
        this.attribName[n] = string;
        this.attribSize[n] = n2;
        this.gl.glBindBufferARB(34962, this.attribVBO[n]);
        this.gl.glBufferDataARB(34962, this.size * n2 * 4, null, this.vboUsage);
        this.gl.glBindBufferARB(34962, 0);
    }

    public void initTextures(int n) {
        this.numTextures = n;
        this.texCoordsVBO = new int[this.numTextures];
        this.textures = new GLTexture[this.numTextures];
        for (n = 0; n < this.numTextures; ++n) {
            this.texCoordsVBO[n] = GLState.createGLResource(1);
            this.gl.glBindBufferARB(34962, this.texCoordsVBO[n]);
            this.gl.glBufferDataARB(34962, this.size * 2 * 4, null, this.vboUsage);
        }
        this.gl.glBindBufferARB(34962, 0);
    }

    public void initIndices(int n) {
        this.initIndices(n, 0);
    }

    public void initIndices(int n, int n2) {
        int n3 = 35044;
        if (n2 == 0) {
            this.vboUsage = 35044;
        } else if (n2 == 1) {
            this.vboUsage = 35048;
        } else if (n2 == 2) {
            this.vboUsage = 35042;
        }
        this.maxIndicesCount = n;
        this.indicesVBO = new int[1];
        this.indicesVBO[0] = GLState.createGLResource(1);
        this.gl.glBindBufferARB(34963, this.indicesVBO[0]);
        this.gl.glBufferDataARB(34963, this.maxIndicesCount * 4, null, n3);
        this.gl.glBindBufferARB(34963, 0);
        this.minIndex = 0;
        this.maxIndex = this.size;
        this.autoIndexBoundCalc = true;
    }

    public void autoIndexBounds(boolean bl) {
        this.autoIndexBoundCalc = bl;
    }

    public void beginUpdateIndices() {
        this.gl.glBindBufferARB(34963, this.indicesVBO[0]);
        ByteBuffer byteBuffer = this.gl.glMapBufferARB(34963, 35001);
        this.indices = byteBuffer.asIntBuffer();
    }

    public void endUpdateIndices() {
        if (this.tmpIndexArray != null) {
            this.indices.put(this.tmpIndexArray);
            this.tmpIndexArray = null;
        }
        this.indices.position(0);
        this.gl.glUnmapBufferARB(34963);
        this.gl.glBindBufferARB(34963, 0);
    }

    public void updateIndices(int[] nArray) {
        this.updateIndices(nArray, nArray.length);
    }

    public void updateIndices(int[] nArray, int n) {
        if (this.maxIndicesCount < n) {
            System.err.println("Wrong number of indices!");
        }
        this.indicesCount = n;
        this.beginUpdateIndices();
        this.indices.put(nArray, 0, n);
        this.endUpdateIndices();
        if (this.autoIndexBoundCalc) {
            this.minIndex = this.size;
            this.maxIndex = -this.size;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] < this.minIndex) {
                    this.minIndex = nArray[i];
                }
                if (this.maxIndex >= nArray[i]) continue;
                this.maxIndex = nArray[i];
            }
        }
    }

    public void setMinIndex(int n) {
        this.minIndex = n;
    }

    public void setMaxIndex(int n) {
        this.maxIndex = n;
    }

    public void setTexture(int n, GLTexture gLTexture) {
        this.textures[n] = gLTexture;
    }

    public int getNumTextures() {
        return this.numTextures;
    }

    public GLTexture getTexture(int n) {
        return this.textures[n];
    }

    public void beginUpdateVertices() {
        this.gl.glBindBufferARB(34962, this.vertCoordsVBO[0]);
        ByteBuffer byteBuffer = this.gl.glMapBufferARB(34962, 35001);
        this.vertices = byteBuffer.asFloatBuffer();
    }

    public void endUpdateVertices() {
        if (this.tmpVertArray != null) {
            this.vertices.put(this.tmpVertArray);
            this.tmpVertArray = null;
        }
        this.vertices.position(0);
        this.gl.glUnmapBufferARB(34962);
        this.gl.glBindBufferARB(34962, 0);
    }

    public ArrayList<PVector> getVertices(String string) {
        ArrayList<PVector> arrayList = new ArrayList<PVector>();
        this.loadPVectorArrayListFromBinary(string, arrayList, 3);
        return arrayList;
    }

    public void saveVertices(String string, ArrayList<PVector> arrayList) {
        this.savePVectorArrayListToBinary(string, arrayList, 3);
    }

    public void loadVertices(String string) {
        float[] fArray = new float[4 * this.size];
        for (int i = 0; i < this.size; ++i) {
            fArray[4 * i + 3] = 1.0f;
        }
        this.beginUpdateVertices();
        this.loadFloatArrayFromBinary(string, fArray, this.size, 4, 3);
        this.vertices.put(fArray);
        this.endUpdateVertices();
    }

    public void saveVertices(String string) {
        float[] fArray = new float[4 * this.size];
        this.beginUpdateVertices();
        this.vertices.get(fArray);
        this.saveFloatArrayToBinary(string, fArray, this.size, 4, 3);
        this.endUpdateVertices();
    }

    public void updateVertex(int n, float f, float f2) {
        this.updateVertex(n, f, f2, 0.0f, 1.0f);
    }

    public void updateVertex(int n, float f, float f2, float f3) {
        this.updateVertex(n, f, f2, f3, 1.0f);
    }

    public void updateVertex(int n, float f, float f2, float f3, float f4) {
        if (this.tmpVertArray == null) {
            this.tmpVertArray = new float[4 * this.size];
            this.vertices.get(this.tmpVertArray);
            this.vertices.rewind();
        }
        this.tmpVertArray[4 * n + 0] = f;
        this.tmpVertArray[4 * n + 1] = f2;
        this.tmpVertArray[4 * n + 2] = f3;
        this.tmpVertArray[4 * n + 3] = f4;
    }

    public void displaceVertex(int n, float f, float f2) {
        this.displaceVertex(n, f, f2, 0.0f, 0.0f);
    }

    public void displaceVertex(int n, float f, float f2, float f3) {
        this.displaceVertex(n, f, f2, f3, 0.0f);
    }

    public void displaceVertex(int n, float f, float f2, float f3, float f4) {
        if (this.tmpVertArray == null) {
            this.tmpVertArray = new float[4 * this.size];
            this.vertices.get(this.tmpVertArray);
            this.vertices.rewind();
        }
        int n2 = 4 * n + 0;
        this.tmpVertArray[n2] = this.tmpVertArray[n2] + f;
        int n3 = 4 * n + 1;
        this.tmpVertArray[n3] = this.tmpVertArray[n3] + f2;
        int n4 = 4 * n + 2;
        this.tmpVertArray[n4] = this.tmpVertArray[n4] + f3;
        int n5 = 4 * n + 3;
        this.tmpVertArray[n5] = this.tmpVertArray[n5] + f4;
    }

    public void updateVertices(float[] fArray) {
        this.beginUpdateVertices();
        this.vertices.put(fArray);
        this.endUpdateVertices();
    }

    public void updateVertices(ArrayList<PVector> arrayList) {
        if (arrayList.size() != this.size) {
            System.err.println("Wrong number of vertices in the array list.");
            return;
        }
        float[] fArray = new float[4 * this.size];
        for (int i = 0; i < arrayList.size(); ++i) {
            PVector pVector = arrayList.get(i);
            fArray[4 * i + 0] = pVector.x;
            fArray[4 * i + 1] = pVector.y;
            fArray[4 * i + 2] = pVector.z;
            fArray[4 * i + 3] = 1.0f;
        }
        this.updateVertices(fArray);
    }

    public void centerVertices() {
        this.centerVertices(0.0f, 0.0f, 0.0f);
    }

    public void centerVertices(float f, float f2) {
        this.centerVertices(f, f2, 0.0f);
    }

    public void centerVertices(float f, float f2, float f3) {
        int n;
        this.beginUpdateVertices();
        this.tmpVertArray = new float[4 * this.size];
        this.vertices.get(this.tmpVertArray);
        this.vertices.rewind();
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (n = 0; n < this.size; ++n) {
            f6 += this.tmpVertArray[4 * n + 0];
            f5 += this.tmpVertArray[4 * n + 1];
            f4 += this.tmpVertArray[4 * n + 2];
        }
        f6 /= (float)this.size;
        f5 /= (float)this.size;
        f4 /= (float)this.size;
        for (n = 0; n < this.size; ++n) {
            int n2 = 4 * n + 0;
            this.tmpVertArray[n2] = this.tmpVertArray[n2] + (f - f6);
            int n3 = 4 * n + 1;
            this.tmpVertArray[n3] = this.tmpVertArray[n3] + (f2 - f5);
            int n4 = 4 * n + 2;
            this.tmpVertArray[n4] = this.tmpVertArray[n4] + (f3 - f4);
        }
        this.endUpdateVertices();
    }

    public void updateBounds() {
        this.beginUpdateVertices();
        this.tmpVertArray = new float[4 * this.size];
        this.vertices.get(this.tmpVertArray);
        this.vertices.rewind();
        this.resetBounds();
        for (int i = 0; i < this.size; ++i) {
            this.updateBounds(this.tmpVertArray[4 * i + 0], this.tmpVertArray[4 * i + 1], this.tmpVertArray[4 * i + 2]);
        }
        this.endUpdateVertices();
    }

    public void updateBounds(int[] nArray, int n) {
        this.beginUpdateVertices();
        this.tmpVertArray = new float[4 * this.size];
        this.vertices.get(this.tmpVertArray);
        this.vertices.rewind();
        this.resetBounds();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            this.updateBounds(this.tmpVertArray[4 * n2 + 0], this.tmpVertArray[4 * n2 + 1], this.tmpVertArray[4 * n2 + 2]);
        }
        this.endUpdateVertices();
    }

    protected void resetBounds() {
        this.depth = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.zmin = 10000.0f;
        this.ymin = 10000.0f;
        this.xmin = 10000.0f;
        this.zmax = -10000.0f;
        this.ymax = -10000.0f;
        this.xmax = -10000.0f;
    }

    protected void updateBounds(float f, float f2, float f3) {
        this.xmin = PApplet.min((float)this.xmin, (float)f);
        this.xmax = PApplet.max((float)this.xmax, (float)f);
        this.ymin = PApplet.min((float)this.ymin, (float)f2);
        this.ymax = PApplet.max((float)this.ymax, (float)f2);
        this.zmin = PApplet.min((float)this.zmin, (float)f3);
        this.zmax = PApplet.max((float)this.zmax, (float)f3);
        this.width = this.xmax - this.xmin;
        this.height = this.ymax - this.ymin;
        this.depth = this.zmax - this.zmin;
    }

    public void beginUpdateColors() {
        this.gl.glBindBufferARB(34962, this.colorsVBO[0]);
        ByteBuffer byteBuffer = this.gl.glMapBufferARB(34962, 35001);
        this.colors = byteBuffer.asFloatBuffer();
    }

    public void endUpdateColors() {
        if (this.tmpColorArray != null) {
            this.colors.put(this.tmpColorArray);
            this.tmpColorArray = null;
        }
        this.colors.position(0);
        this.gl.glUnmapBufferARB(34962);
        this.gl.glBindBufferARB(34962, 0);
    }

    public ArrayList<float[]> getColors(String string) {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        this.loadFloatArrayListFromBinary(string, arrayList, 4);
        return arrayList;
    }

    public void saveColors(String string, ArrayList<float[]> arrayList) {
        this.saveFloatArrayToBinary(string, arrayList, 4);
    }

    public void loadColors(String string) {
        float[] fArray = new float[4 * this.size];
        this.beginUpdateColors();
        this.loadFloatArrayFromBinary(string, fArray, this.size, 4, 4);
        this.colors.put(fArray);
        this.endUpdateColors();
    }

    public void saveColors(String string) {
        float[] fArray = new float[4 * this.size];
        this.beginUpdateColors();
        this.colors.get(fArray);
        this.saveFloatArrayToBinary(string, fArray, this.size, 4, 4);
        this.endUpdateColors();
    }

    public void updateColor(int n, float f) {
        int n2 = this.parent.color(f);
        this.putColorInTmpArray(n, n2);
    }

    public void updateColor(int n, int n2, int n3) {
        int n4 = this.parent.color(n2, n3);
        this.putColorInTmpArray(n, n4);
    }

    public void updateColor(int n, int n2, float f) {
        int n3 = this.parent.color((float)n2, f);
        this.putColorInTmpArray(n, n3);
    }

    public void updateColor(int n, float f, float f2) {
        int n2 = this.parent.color(f, f2);
        this.putColorInTmpArray(n, n2);
    }

    public void updateColor(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n2, n3, n4);
        this.putColorInTmpArray(n, n5);
    }

    public void updateColor(int n, float f, float f2, float f3) {
        int n2 = this.parent.color(f, f2, f3);
        this.putColorInTmpArray(n, n2);
    }

    public void updateColor(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.parent.color(n2, n3, n4, n5);
        this.putColorInTmpArray(n, n6);
    }

    public void updateColor(int n, float f, float f2, float f3, float f4) {
        int n2 = this.parent.color(f, f2, f3, f4);
        this.putColorInTmpArray(n, n2);
    }

    public void setColors(float f) {
        int n = this.parent.color(f);
        this.updateAllColors(n);
    }

    public void setColors(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.updateAllColors(n3);
    }

    public void setColors(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.updateAllColors(n2);
    }

    public void setColors(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.updateAllColors(n);
    }

    public void setColors(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.updateAllColors(n4);
    }

    public void setColors(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.updateAllColors(n);
    }

    public void setColors(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.updateAllColors(n5);
    }

    public void setColors(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.updateAllColors(n);
    }

    public void updateColors(float[] fArray) {
        this.beginUpdateColors();
        this.colors.put(fArray);
        this.endUpdateColors();
    }

    public void updateColors(ArrayList<float[]> arrayList) {
        if (arrayList.size() != this.size) {
            System.err.println("Wrong number of colors in the array list.");
            return;
        }
        float[] fArray = new float[4 * this.size];
        for (int i = 0; i < arrayList.size(); ++i) {
            float[] fArray2 = arrayList.get(i);
            if (fArray2.length != 4) continue;
            fArray[4 * i + 0] = fArray2[0];
            fArray[4 * i + 1] = fArray2[1];
            fArray[4 * i + 2] = fArray2[2];
            fArray[4 * i + 3] = fArray2[3];
        }
        this.updateColors(fArray);
    }

    public void beginUpdateTexCoords(int n) {
        this.gl.glBindBufferARB(34962, this.texCoordsVBO[n]);
        ByteBuffer byteBuffer = this.gl.glMapBufferARB(34962, 35001);
        this.texCoords = byteBuffer.asFloatBuffer();
    }

    public void updateTexCoord(int n, float f, float f2) {
        if (this.tmpTexCoordsArray == null) {
            this.tmpTexCoordsArray = new float[2 * this.size];
            this.texCoords.get(this.tmpTexCoordsArray);
            this.texCoords.rewind();
        }
        this.tmpTexCoordsArray[2 * n + 0] = f;
        this.tmpTexCoordsArray[2 * n + 1] = f2;
    }

    public ArrayList<PVector> getTexCoords(String string) {
        ArrayList<PVector> arrayList = new ArrayList<PVector>();
        this.loadPVectorArrayListFromBinary(string, arrayList, 2);
        return arrayList;
    }

    public void saveTexCoords(String string, ArrayList<PVector> arrayList) {
        this.savePVectorArrayListToBinary(string, arrayList, 2);
    }

    public void loadTexCoords(int n, String string) {
        float[] fArray = new float[2 * this.size];
        this.beginUpdateTexCoords(n);
        this.loadFloatArrayFromBinary(string, fArray, this.size, 2, 2);
        this.texCoords.put(fArray);
        this.endUpdateTexCoords();
    }

    public void saveTexCoords(int n, String string) {
        float[] fArray = new float[2 * this.size];
        this.beginUpdateTexCoords(n);
        this.texCoords.get(fArray);
        this.saveFloatArrayToBinary(string, fArray, this.size, 2, 2);
        this.endUpdateTexCoords();
    }

    public void displaceTexCoord(int n, float f, float f2) {
        if (this.tmpTexCoordsArray == null) {
            this.tmpTexCoordsArray = new float[2 * this.size];
            this.texCoords.get(this.tmpTexCoordsArray);
            this.texCoords.rewind();
        }
        int n2 = 2 * n + 0;
        this.tmpTexCoordsArray[n2] = this.tmpTexCoordsArray[n2] + f;
        int n3 = 2 * n + 1;
        this.tmpTexCoordsArray[n3] = this.tmpTexCoordsArray[n3] + f2;
    }

    public void endUpdateTexCoords() {
        if (this.tmpTexCoordsArray != null) {
            this.texCoords.put(this.tmpTexCoordsArray);
            this.tmpTexCoordsArray = null;
        }
        this.texCoords.position(0);
        this.gl.glUnmapBufferARB(34962);
        this.gl.glBindBufferARB(34962, 0);
    }

    public void updateTexCoords(int n, float[] fArray) {
        this.beginUpdateTexCoords(n);
        this.texCoords.put(fArray);
        this.endUpdateTexCoords();
    }

    public void updateTexCoords(int n, ArrayList<PVector> arrayList) {
        if (arrayList.size() != this.size) {
            System.err.println("Wrong number of texture coordinates in the array list.");
            return;
        }
        float[] fArray = new float[2 * this.size];
        for (int i = 0; i < arrayList.size(); ++i) {
            PVector pVector = arrayList.get(i);
            fArray[2 * i + 0] = pVector.x;
            fArray[2 * i + 1] = pVector.y;
        }
        this.updateTexCoords(n, fArray);
    }

    public void beginUpdateNormals() {
        this.gl.glBindBufferARB(34962, this.normCoordsVBO[0]);
        ByteBuffer byteBuffer = this.gl.glMapBufferARB(34962, 35001);
        this.normals = byteBuffer.asFloatBuffer();
    }

    public void endUpdateNormals() {
        if (this.tmpNormalsArray != null) {
            this.normals.put(this.tmpNormalsArray);
            this.tmpNormalsArray = null;
        }
        this.normals.position(0);
        this.gl.glUnmapBufferARB(34962);
        this.gl.glBindBufferARB(34962, 0);
    }

    public ArrayList<PVector> getNormals(String string) {
        ArrayList<PVector> arrayList = new ArrayList<PVector>();
        this.loadPVectorArrayListFromBinary(string, arrayList, 3);
        return arrayList;
    }

    public void saveNormals(String string, ArrayList<PVector> arrayList) {
        this.savePVectorArrayListToBinary(string, arrayList, 3);
    }

    public void loadNormals(String string) {
        float[] fArray = new float[4 * this.size];
        this.beginUpdateNormals();
        this.loadFloatArrayFromBinary(string, fArray, this.size, 4, 3);
        this.normals.put(fArray);
        this.endUpdateNormals();
    }

    public void saveNormals(String string) {
        float[] fArray = new float[4 * this.size];
        this.beginUpdateNormals();
        this.normals.get(fArray);
        this.saveFloatArrayToBinary(string, fArray, this.size, 4, 3);
        this.endUpdateNormals();
    }

    public void updateNormal(int n, float f, float f2) {
        this.updateNormal(n, f, f2, 0.0f, 0.0f);
    }

    public void updateNormal(int n, float f, float f2, float f3) {
        this.updateNormal(n, f, f2, f3, 0.0f);
    }

    public void updateNormal(int n, float f, float f2, float f3, float f4) {
        if (this.tmpNormalsArray == null) {
            this.tmpNormalsArray = new float[4 * this.size];
            this.normals.get(this.tmpNormalsArray);
            this.normals.rewind();
        }
        this.tmpNormalsArray[4 * n + 0] = f;
        this.tmpNormalsArray[4 * n + 1] = f2;
        this.tmpNormalsArray[4 * n + 2] = f3;
        this.tmpNormalsArray[4 * n + 3] = f4;
    }

    public void displaceNormal(int n, float f, float f2) {
        this.displaceNormal(n, f, f2, 0.0f, 0.0f);
    }

    public void displaceNormal(int n, float f, float f2, float f3) {
        this.displaceNormal(n, f, f2, f3, 0.0f);
    }

    public void displaceNormal(int n, float f, float f2, float f3, float f4) {
        if (this.tmpNormalsArray == null) {
            this.tmpNormalsArray = new float[4 * this.size];
            this.normals.get(this.tmpNormalsArray);
            this.normals.rewind();
        }
        int n2 = 4 * n + 0;
        this.tmpNormalsArray[n2] = this.tmpNormalsArray[n2] + f;
        int n3 = 4 * n + 1;
        this.tmpNormalsArray[n3] = this.tmpNormalsArray[n3] + f2;
        int n4 = 4 * n + 2;
        this.tmpNormalsArray[n4] = this.tmpNormalsArray[n4] + f3;
        int n5 = 4 * n + 3;
        this.tmpNormalsArray[n5] = this.tmpNormalsArray[n5] + f4;
    }

    public void updateNormals(float[] fArray) {
        this.beginUpdateNormals();
        this.normals.put(fArray);
        this.endUpdateNormals();
    }

    public void updateNormals(ArrayList<PVector> arrayList) {
        if (arrayList.size() != this.size) {
            System.err.println("Wrong number of normals in the array list.");
            return;
        }
        float[] fArray = new float[4 * this.size];
        for (int i = 0; i < arrayList.size(); ++i) {
            PVector pVector = arrayList.get(i);
            fArray[4 * i + 0] = pVector.x;
            fArray[4 * i + 1] = pVector.y;
            fArray[4 * i + 2] = pVector.z;
            fArray[4 * i + 3] = 0.0f;
        }
        this.updateNormals(fArray);
    }

    public void beginUpdateAttributes(int n) {
        this.gl.glBindBufferARB(34962, this.attribVBO[n]);
        ByteBuffer byteBuffer = this.gl.glMapBufferARB(34962, 35001);
        this.attributes = byteBuffer.asFloatBuffer();
        this.curtAttrSize = this.attribSize[n];
    }

    public void endUpdateAttributes() {
        if (this.tmpAttributesArray != null) {
            this.attributes.put(this.tmpAttributesArray);
            this.tmpAttributesArray = null;
        }
        this.attributes.position(0);
        this.gl.glUnmapBufferARB(34962);
        this.gl.glBindBufferARB(34962, 0);
    }

    public ArrayList<float[]> getAttributes(String string, int n) {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        this.loadFloatArrayListFromBinary(string, arrayList, n);
        return arrayList;
    }

    public void saveAttributes(String string, ArrayList<float[]> arrayList, int n) {
        this.saveFloatArrayToBinary(string, arrayList, n);
    }

    public void loadAttributes(int n, String string) {
        int n2 = this.attribSize[n];
        float[] fArray = new float[n2 * this.size];
        this.beginUpdateAttributes(n);
        this.loadFloatArrayFromBinary(string, fArray, this.size, n2, n2);
        this.attributes.put(fArray);
        this.endUpdateAttributes();
    }

    public void saveAttributes(int n, String string) {
        int n2 = this.attribSize[n];
        float[] fArray = new float[n2 * this.size];
        this.beginUpdateAttributes(n);
        this.attributes.get(fArray);
        this.saveFloatArrayToBinary(string, fArray, this.size, n2, n2);
        this.endUpdateAttributes();
    }

    public void updateAttribute(int n, float f) {
        this.updateAttribute(n, new float[]{f});
    }

    public void updateAttribute(int n, float f, float f2) {
        this.updateAttribute(n, new float[]{f, f2});
    }

    public void updateAttribute(int n, float f, float f2, float f3) {
        this.updateAttribute(n, new float[]{f, f2, f3});
    }

    public void updateAttribute(int n, float f, float f2, float f3, float f4) {
        this.updateAttribute(n, new float[]{f, f2, f3, f4});
    }

    public void updateAttribute(int n, float[] fArray) {
        if (fArray.length == this.curtAttrSize) {
            if (this.tmpAttributesArray == null) {
                this.tmpAttributesArray = new float[this.curtAttrSize * this.size];
                this.attributes.get(this.tmpAttributesArray);
                this.attributes.rewind();
            }
            for (int i = 0; i < this.curtAttrSize; ++i) {
                this.tmpAttributesArray[this.curtAttrSize * n + i] = fArray[i];
            }
        }
    }

    public void displaceAttribute(int n, float f) {
        this.displaceAttribute(n, new float[]{f});
    }

    public void displaceAttribute(int n, float f, float f2) {
        this.displaceAttribute(n, new float[]{f, f2});
    }

    public void displaceAttribute(int n, float f, float f2, float f3) {
        this.displaceAttribute(n, new float[]{f, f2, f3});
    }

    public void displaceAttribute(int n, float f, float f2, float f3, float f4) {
        this.displaceAttribute(n, new float[]{f, f2, f3, f4});
    }

    public void displaceAttribute(int n, float[] fArray) {
        int n2 = this.attribSize[n];
        if (fArray.length == n2) {
            if (this.tmpAttributesArray == null) {
                this.tmpAttributesArray = new float[n2 * this.size];
                this.attributes.get(this.tmpAttributesArray);
                this.attributes.rewind();
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = n2 * n + i;
                this.tmpAttributesArray[n3] = this.tmpAttributesArray[n3] + fArray[i];
            }
        }
    }

    public void updateAttributes(int n, float[] fArray) {
        this.beginUpdateAttributes(n);
        this.attributes.put(fArray);
        this.endUpdateAttributes();
    }

    public void updateAttributes(int n, ArrayList<float[]> arrayList) {
        if (arrayList.size() != this.size) {
            System.err.println("Wrong number of vertex attributes in the array list.");
            return;
        }
        int n2 = this.attribSize[n];
        float[] fArray = new float[n2 * this.size];
        for (int i = 0; i < arrayList.size(); ++i) {
            float[] fArray2 = arrayList.get(i);
            for (int j = 0; j < n2; ++j) {
                fArray[n2 * i + j] = fArray2[j];
            }
        }
        this.updateAttributes(n, fArray);
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public void setPointSize(float f) {
        this.pointSize = PApplet.min((float)this.maxPointSize, (float)f);
    }

    public float getMaxPointSize() {
        return this.maxPointSize;
    }

    public void setMaxSpriteSize(float f) {
        this.maxSpriteSize = PApplet.min((float)this.maxPointSize, (float)f);
    }

    public void setSpriteSize(float f) {
        this.setMaxSpriteSize(f);
        this.spriteDistAtt[1] = 0.0f;
        this.spriteDistAtt[2] = 0.0f;
    }

    public void setSpriteSize(float f, float f2) {
        this.setSpriteSize(f, f2, true);
    }

    public void setSpriteSize(float f, float f2, boolean bl) {
        float f3 = this.maxSpriteSize;
        if (bl) {
            this.spriteDistAtt[1] = 0.0f;
            this.spriteDistAtt[2] = (f3 - f) / (f2 * f2 * f);
        } else {
            this.spriteDistAtt[1] = (f3 - f) / (f2 * f);
            this.spriteDistAtt[2] = 0.0f;
        }
    }

    public void noBlend() {
        this.blend = false;
    }

    public void setBlendMode(int n) {
        this.blend = true;
        this.blendMode = n;
    }

    public void setTint(float f) {
        int n = this.parent.color(f);
        this.setTintColor(n);
    }

    public void setTint(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.setTintColor(n3);
    }

    public void setTint(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.setTintColor(n2);
    }

    public void setTint(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.setTintColor(n);
    }

    public void setTint(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.setTintColor(n4);
    }

    public void setTint(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.setTintColor(n);
    }

    public void setTint(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.setTintColor(n5);
    }

    public void setTint(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.setTintColor(n);
    }

    protected void setTintColor(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        this.tintA = (float)n2 / 255.0f;
        this.tintR = (float)n3 / 255.0f;
        this.tintG = (float)n4 / 255.0f;
        this.tintB = (float)n5 / 255.0f;
    }

    public void setReflection(float f) {
        int n = this.parent.color(f);
        this.setSpecularColor(n);
    }

    public void setReflection(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.setSpecularColor(n3);
    }

    public void setReflection(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.setSpecularColor(n2);
    }

    public void setReflection(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.setSpecularColor(n);
    }

    public void setReflection(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.setSpecularColor(n4);
    }

    public void setReflection(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.setSpecularColor(n);
    }

    public void setReflection(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.setSpecularColor(n5);
    }

    public void setReflection(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.setSpecularColor(n);
    }

    protected void setSpecularColor(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        this.specularColor[0] = (float)n3 / 255.0f;
        this.specularColor[1] = (float)n4 / 255.0f;
        this.specularColor[2] = (float)n5 / 255.0f;
        this.specularColor[3] = (float)n2 / 255.0f;
    }

    public void setEmission(float f) {
        int n = this.parent.color(f);
        this.setEmissiveColor(n);
    }

    public void setEmission(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.setEmissiveColor(n3);
    }

    public void setEmission(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.setEmissiveColor(n2);
    }

    public void setEmission(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.setEmissiveColor(n);
    }

    public void setEmission(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.setEmissiveColor(n4);
    }

    public void setEmission(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.setEmissiveColor(n);
    }

    public void setEmission(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.setEmissiveColor(n5);
    }

    public void setEmission(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.setEmissiveColor(n);
    }

    public void setShininess(float f) {
        this.shininess[0] = f;
    }

    protected void setEmissiveColor(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        this.emissiveColor[0] = (float)n3 / 255.0f;
        this.emissiveColor[1] = (float)n4 / 255.0f;
        this.emissiveColor[2] = (float)n5 / 255.0f;
        this.emissiveColor[3] = (float)n2 / 255.0f;
    }

    public void render() {
        if (this.indicesVBO == null) {
            this.render(0, this.size - 1, null);
        } else {
            this.render(0, this.indicesCount, null);
        }
    }

    public void render(GLModelEffect gLModelEffect) {
        if (this.indicesVBO == null) {
            this.render(0, this.size - 1, gLModelEffect);
        } else {
            this.render(0, this.indicesCount, gLModelEffect);
        }
    }

    public void render(int n, int n2) {
        this.render(0, this.size - 1, null);
    }

    public void render(int n, int n2, GLModelEffect gLModelEffect) {
        int n3;
        if (this.colorsVBO == null) {
            this.gl.glColor4f(this.tintR, this.tintG, this.tintB, this.tintA);
        }
        this.glstate.saveBlendConfig();
        if (this.blend) {
            this.glstate.enableBlend();
            this.glstate.setupBlending(this.blendMode);
        } else {
            this.glstate.disableBlend();
        }
        this.gl.glMaterialfv(1032, 4610, this.specularColor, 0);
        this.gl.glMaterialfv(1032, 5632, this.emissiveColor, 0);
        this.gl.glMaterialfv(1032, 5633, this.shininess, 0);
        this.gl.glLineWidth(this.lineWidth);
        if (!this.usingPointSprites) {
            this.gl.glPointSize(this.pointSize);
        }
        if (gLModelEffect != null) {
            gLModelEffect.start();
        }
        if (this.normCoordsVBO != null) {
            this.gl.glEnableClientState(32885);
            this.gl.glBindBufferARB(34962, this.normCoordsVBO[0]);
            this.gl.glNormalPointer(5126, 16, 0L);
        }
        if (this.colorsVBO != null) {
            this.gl.glEnableClientState(32886);
            this.gl.glBindBufferARB(34962, this.colorsVBO[0]);
            this.gl.glColorPointer(4, 5126, 0, 0L);
        }
        if (this.indicesVBO != null) {
            this.gl.glBindBufferARB(34963, this.indicesVBO[0]);
        }
        if (this.texCoordsVBO != null) {
            this.gl.glEnable(this.textures[0].getTextureTarget());
            for (n3 = 0; n3 < this.numTextures; ++n3) {
                this.textures[n3].bind(n3);
            }
            if (this.usingPointSprites) {
                this.gl.glPointParameterfARB(33064, 0.6f * this.maxSpriteSize);
                this.gl.glPointParameterfARB(33062, 1.0f);
                this.gl.glPointParameterfARB(33063, this.maxSpriteSize);
                this.gl.glPointSize(this.maxSpriteSize);
                this.gl.glPointParameterfvARB(33065, this.spriteDistAtt, 0);
                this.gl.glTexEnvf(34913, 34914, 1.0f);
                this.gl.glEnable(34913);
            } else {
                this.gl.glEnableClientState(32888);
                for (n3 = 0; n3 < this.numTextures; ++n3) {
                    this.gl.glClientActiveTexture(33984 + n3);
                    this.gl.glBindBufferARB(34962, this.texCoordsVBO[n3]);
                    this.gl.glTexCoordPointer(2, 5126, 0, 0L);
                }
            }
            if (gLModelEffect != null) {
                gLModelEffect.setTextures(this.textures);
            }
        }
        this.gl.glEnableClientState(32884);
        if (gLModelEffect != null) {
            gLModelEffect.enableVertexAttribs();
            gLModelEffect.setVertexAttribs(this.attribVBO, this.attribName, this.attribSize);
        }
        this.gl.glBindBufferARB(34962, this.vertCoordsVBO[0]);
        this.gl.glVertexPointer(4, 5126, 0, 0L);
        if (this.indicesVBO == null) {
            this.gl.glDrawArrays(this.vertexMode, n, n2 - n + 1);
        } else {
            this.gl.glDrawRangeElements(this.vertexMode, this.minIndex, this.maxIndex, n2 - n + 1, 5125, (long)(n * 4));
        }
        if (gLModelEffect != null) {
            gLModelEffect.disableVertexAttribs();
        }
        this.gl.glBindBuffer(34962, 0);
        this.gl.glDisableClientState(32884);
        if (this.texCoordsVBO != null) {
            if (this.usingPointSprites) {
                this.gl.glDisable(34913);
            } else {
                for (n3 = 0; n3 < this.numTextures; ++n3) {
                    this.gl.glClientActiveTexture(33984 + n3);
                    this.gl.glBindBufferARB(34962, 0);
                }
                this.gl.glDisableClientState(32888);
            }
            for (n3 = 0; n3 < this.numTextures; ++n3) {
                this.textures[n3].unbind();
            }
            this.gl.glDisable(this.textures[0].getTextureTarget());
        }
        if (this.colorsVBO != null) {
            this.gl.glBindBufferARB(34962, 0);
            this.gl.glDisableClientState(32886);
        }
        if (this.normCoordsVBO != null) {
            this.gl.glBindBufferARB(34962, 0);
            this.gl.glDisableClientState(32885);
        }
        if (this.indicesVBO != null) {
            this.gl.glBindBufferARB(34963, 0);
        }
        if (gLModelEffect != null) {
            gLModelEffect.stop();
        }
        this.glstate.restoreBlendConfig();
    }

    protected void loadPVectorArrayListFromBinary(String string, ArrayList<PVector> arrayList, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.parent.dataPath("") + string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() > 2) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                if (1 <= n) {
                    f3 = (float)dataInputStream.readShort() / 100.0f;
                }
                if (2 <= n) {
                    f2 = (float)dataInputStream.readShort() / 100.0f;
                }
                if (3 <= n) {
                    f = (float)dataInputStream.readShort() / 100.0f;
                }
                PVector pVector = new PVector(f3, f2, f);
                arrayList.add(pVector);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    protected void savePVectorArrayListToBinary(String string, ArrayList<PVector> arrayList, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < arrayList.size(); ++i) {
            PVector pVector = arrayList.get(i);
            try {
                if (1 <= n) {
                    dataOutputStream.writeShort((short)(pVector.x * 100.0f));
                }
                if (2 <= n) {
                    dataOutputStream.writeShort((short)(pVector.y * 100.0f));
                }
                if (3 <= n) {
                    dataOutputStream.writeShort((short)(pVector.z * 100.0f));
                }
                dataOutputStream.flush();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.parent.saveBytes(string, byArray);
    }

    protected void loadFloatArrayListFromBinary(String string, ArrayList<float[]> arrayList, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.parent.dataPath("") + string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() > 2) {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = (float)dataInputStream.readShort() / 100.0f;
                }
                arrayList.add(fArray);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    protected void saveFloatArrayToBinary(String string, ArrayList<float[]> arrayList, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < arrayList.size(); ++i) {
            float[] fArray = arrayList.get(i);
            try {
                for (int j = 0; j < n; ++j) {
                    dataOutputStream.writeShort((short)(fArray[j] * 100.0f));
                }
                dataOutputStream.flush();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.parent.saveBytes(string, byArray);
    }

    protected void loadFloatArrayFromBinary(String string, float[] fArray, int n, int n2, int n3) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.parent.dataPath("") + string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    fArray[n2 * i + j] = (float)dataInputStream.readShort() / 100.0f;
                }
                if (dataInputStream.available() <= 2) break;
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    protected void saveFloatArrayToBinary(String string, float[] fArray, int n, int n2, int n3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < n; ++i) {
            try {
                for (int j = 0; j < n3; ++j) {
                    dataOutputStream.writeShort((short)(fArray[n2 * i + j] * 100.0f));
                }
                dataOutputStream.flush();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.parent.saveBytes(string, byArray);
    }

    protected void putColorInTmpArray(int n, int n2) {
        if (this.tmpColorArray == null) {
            this.tmpColorArray = new float[4 * this.size];
            this.colors.get(this.tmpColorArray);
            this.colors.rewind();
        }
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        this.tmpColorArray[4 * n + 0] = (float)n4 / 255.0f;
        this.tmpColorArray[4 * n + 1] = (float)n5 / 255.0f;
        this.tmpColorArray[4 * n + 2] = (float)n6 / 255.0f;
        this.tmpColorArray[4 * n + 3] = (float)n3 / 255.0f;
    }

    protected void updateAllColors(int n) {
        this.beginUpdateColors();
        if (this.tmpColorArray == null) {
            this.tmpColorArray = new float[4 * this.size];
            this.colors.get(this.tmpColorArray);
            this.colors.rewind();
        }
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        float f = (float)n2 / 255.0f;
        float f2 = (float)n3 / 255.0f;
        float f3 = (float)n4 / 255.0f;
        float f4 = (float)n5 / 255.0f;
        for (int i = 0; i < this.size; ++i) {
            this.tmpColorArray[4 * i + 0] = f2;
            this.tmpColorArray[4 * i + 1] = f3;
            this.tmpColorArray[4 * i + 2] = f4;
            this.tmpColorArray[4 * i + 3] = f;
        }
        this.endUpdateColors();
    }

    protected void initModelCommon(PApplet pApplet) {
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.tintA = 1.0f;
        this.tintB = 1.0f;
        this.tintG = 1.0f;
        this.tintR = 1.0f;
        this.shininess[0] = 0.0f;
        this.pointSize = 1.0f;
        this.lineWidth = 1.0f;
        this.usingPointSprites = false;
        this.blend = true;
        this.blendMode = 1;
        this.tmpVertArray = null;
        this.tmpColorArray = null;
        this.tmpNormalsArray = null;
        this.tmpTexCoordsArray = null;
        this.tmpAttributesArray = null;
    }

    protected void releaseModel() {
        int n;
        if (this.vertCoordsVBO[0] != 0) {
            GLState.deleteGLResource(this.vertCoordsVBO[0], 1);
        }
        if (this.colorsVBO != null && this.colorsVBO[0] != 0) {
            GLState.deleteGLResource(this.colorsVBO[0], 1);
        }
        if (this.normCoordsVBO != null && this.normCoordsVBO[0] != 0) {
            GLState.deleteGLResource(this.normCoordsVBO[0], 1);
        }
        if (this.texCoordsVBO != null && this.texCoordsVBO[0] != 0) {
            for (n = 0; n < this.numTextures; ++n) {
                GLState.deleteGLResource(this.texCoordsVBO[n], 1);
            }
        }
        if (this.indicesVBO != null && this.indicesVBO[0] != 0) {
            GLState.deleteGLResource(this.indicesVBO[0], 1);
        }
        if (this.attribVBO != null && this.attribVBO[0] != 0) {
            for (n = 0; n < this.numAttributes; ++n) {
                GLState.deleteGLResource(this.attribVBO[n], 1);
            }
        }
    }

    protected void loadXML(XMLElement xMLElement) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4 = xMLElement.getChildCount();
        GLTexture[] gLTextureArray = null;
        ArrayList<PVector> arrayList = new ArrayList<PVector>();
        ArrayList[] arrayListArray = null;
        ArrayList[] arrayListArray2 = null;
        ArrayList<PVector> arrayList2 = new ArrayList<PVector>();
        ArrayList<float[]> arrayList3 = new ArrayList<float[]>();
        String[] stringArray = null;
        String[] stringArray2 = null;
        int[] nArray = null;
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            XMLElement xMLElement2 = xMLElement.getChild(n3);
            String string = xMLElement2.getName();
            if (string.equals("description")) {
                this.description = xMLElement2.getContent();
                continue;
            }
            if (string.equals("size")) {
                this.size = PApplet.parseInt((String)xMLElement2.getContent());
                continue;
            }
            if (string.equals("geometry")) {
                String string2 = xMLElement2.getContent();
                this.vertexMode = GLUtils.parsePrimitive(string2);
                if (this.vertexMode != 0 || !string2.equals("POINT_SPRITES")) continue;
                this.vertexMode = 0;
                this.usingPointSprites = true;
                float[] fArray = new float[]{0.0f};
                this.gl.glGetFloatv(33063, fArray, 0);
                this.maxSpriteSize = this.maxPointSize = fArray[0];
                continue;
            }
            if (string.equals("mode")) {
                this.vboUsage = GLUtils.parseVBOMode(xMLElement2.getContent());
                continue;
            }
            if (string.equals("textures")) {
                int n6 = xMLElement2.getChildCount();
                gLTextureArray = new GLTexture[n6];
                stringArray = new String[n6];
                arrayListArray = new ArrayList[n6];
                this.loadTextures(xMLElement2, gLTextureArray, arrayListArray, stringArray);
                continue;
            }
            if (string.equals("vertexattribs")) {
                int n7 = xMLElement2.getChildCount();
                arrayListArray2 = new ArrayList[n7];
                stringArray2 = new String[n7];
                nArray = new int[n7];
                this.loadVertexAttribs(xMLElement2, arrayListArray2, stringArray2, nArray);
                continue;
            }
            if (string.equals("vertices")) {
                String string3 = xMLElement2.getStringAttribute("file");
                if (string3 != null) {
                    this.loadVertices(string3, arrayList);
                    continue;
                }
                this.loadVertices(xMLElement2, arrayList);
                continue;
            }
            if (string.equals("texcoords")) {
                int n8;
                if (arrayListArray == null || arrayListArray[n8 = xMLElement2.getIntAttribute("unit")] == null) continue;
                object = xMLElement2.getStringAttribute("file");
                if (object != null) {
                    this.loadTexCoords((String)object, (ArrayList<PVector>)arrayListArray[n8]);
                    continue;
                }
                this.loadTexCoords(xMLElement2, (ArrayList<PVector>)arrayListArray[n8]);
                continue;
            }
            if (string.equals("colors")) {
                String string4 = xMLElement2.getStringAttribute("file");
                if (string4 != null) {
                    this.loadColors(string4, arrayList3);
                    continue;
                }
                this.loadColors(xMLElement2, arrayList3);
                continue;
            }
            if (string.equals("normals")) {
                String string5 = xMLElement2.getStringAttribute("file");
                if (string5 != null) {
                    this.loadNormals(string5, arrayList2);
                    continue;
                }
                this.loadNormals(xMLElement2, arrayList2);
                continue;
            }
            if (!string.equals("attribs") || arrayListArray2 == null || nArray == null || arrayListArray2[n5 = xMLElement2.getIntAttribute("number")] == null) continue;
            object = xMLElement2.getStringAttribute("file");
            if (object != null) {
                this.loadVertexAttrib((String)object, (ArrayList<float[]>)arrayListArray2[n5], nArray[n5]);
                continue;
            }
            this.loadVertexAttrib(xMLElement2, (ArrayList<float[]>)arrayListArray2[n5], nArray[n5]);
        }
        this.vertCoordsVBO[0] = GLState.createGLResource(1);
        this.gl.glBindBufferARB(34962, this.vertCoordsVBO[0]);
        this.gl.glBufferDataARB(34962, this.size * 4 * 4, null, this.vboUsage);
        this.gl.glBindBufferARB(34962, 0);
        this.updateVertices(arrayList);
        n3 = gLTextureArray.length;
        if (0 < n3) {
            this.initTextures(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                GLTexture gLTexture = gLTextureArray[n2];
                this.setTexture(n2, gLTexture);
                object = arrayListArray[n2];
                if (((ArrayList)object).size() != this.size) continue;
                this.updateTexCoords(n2, (ArrayList<PVector>)object);
            }
        }
        if (arrayList2.size() == this.size) {
            this.initNormals();
            this.updateNormals(arrayList2);
        }
        if (arrayList3.size() == this.size) {
            this.initColors();
            this.updateColors(arrayList3);
        }
        if (0 < (n = arrayListArray2.length)) {
            this.initAttributes(n);
            for (n2 = 0; n2 < n; ++n2) {
                this.setAttribute(n2, stringArray2[n2], nArray[n2]);
                object = arrayListArray2[n2];
                this.updateAttributes(n2, (ArrayList<float[]>)object);
            }
        }
    }

    protected void loadTextures(XMLElement xMLElement, GLTexture[] gLTextureArray, ArrayList<PVector>[] arrayListArray, String[] stringArray) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("texture")) continue;
            String string2 = xMLElement2.getContent();
            int n2 = PApplet.parseInt((String)string2);
            arrayListArray[n2] = new ArrayList();
            stringArray[n2] = xMLElement2.getStringAttribute("name");
            String string3 = xMLElement2.getStringAttribute("file");
            gLTextureArray[n2] = new GLTexture(this.parent, string3);
            gLTextureArray[n2].setName(stringArray[n2]);
        }
    }

    protected void loadVertexAttribs(XMLElement xMLElement, ArrayList<float[]>[] arrayListArray, String[] stringArray, int[] nArray) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("vertexattrib")) continue;
            String string2 = xMLElement2.getContent();
            int n2 = PApplet.parseInt((String)string2);
            arrayListArray[n2] = new ArrayList();
            stringArray[n2] = xMLElement2.getStringAttribute("name");
            nArray[n2] = xMLElement2.getIntAttribute("size");
        }
    }

    protected void loadVertices(XMLElement xMLElement, ArrayList<PVector> arrayList) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            String string;
            float[] fArray;
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string2 = xMLElement2.getName();
            if (!string2.equals("vertex") || (fArray = PApplet.parseFloat((String[])PApplet.split((String)(string = xMLElement2.getContent()), (char)' '))).length != 3) continue;
            arrayList.add(new PVector(fArray[0], fArray[1], fArray[2]));
        }
    }

    protected void loadVertices(String string, ArrayList<PVector> arrayList) {
        this.loadPVectorArrayListFromBinary(string, arrayList, 3);
    }

    protected void loadTexCoords(XMLElement xMLElement, ArrayList<PVector> arrayList) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            String string;
            float[] fArray;
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string2 = xMLElement2.getName();
            if (!string2.equals("texcoord") || (fArray = PApplet.parseFloat((String[])PApplet.split((String)(string = xMLElement2.getContent()), (char)' '))).length != 2) continue;
            arrayList.add(new PVector(fArray[0], fArray[1]));
        }
    }

    protected void loadTexCoords(String string, ArrayList<PVector> arrayList) {
        this.loadPVectorArrayListFromBinary(string, arrayList, 2);
    }

    protected void loadColors(XMLElement xMLElement, ArrayList<float[]> arrayList) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            String string;
            float[] fArray;
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string2 = xMLElement2.getName();
            if (!string2.equals("color") || (fArray = PApplet.parseFloat((String[])PApplet.split((String)(string = xMLElement2.getContent()), (char)' '))).length != 4) continue;
            arrayList.add(fArray);
        }
    }

    protected void loadColors(String string, ArrayList<float[]> arrayList) {
        this.loadFloatArrayListFromBinary(string, arrayList, 4);
    }

    protected void loadNormals(XMLElement xMLElement, ArrayList<PVector> arrayList) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            String string;
            float[] fArray;
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string2 = xMLElement2.getName();
            if (!string2.equals("normal") || (fArray = PApplet.parseFloat((String[])PApplet.split((String)(string = xMLElement2.getContent()), (char)' '))).length != 3) continue;
            arrayList.add(new PVector(fArray[0], fArray[1], fArray[2]));
        }
    }

    protected void loadNormals(String string, ArrayList<PVector> arrayList) {
        this.loadPVectorArrayListFromBinary(string, arrayList, 3);
    }

    protected void loadVertexAttrib(XMLElement xMLElement, ArrayList<float[]> arrayList, int n) {
        int n2 = xMLElement.getChildCount();
        for (int i = 0; i < n2; ++i) {
            String string;
            float[] fArray;
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string2 = xMLElement2.getName();
            if (!string2.equals("attrib") || (fArray = PApplet.parseFloat((String[])PApplet.split((String)(string = xMLElement2.getContent()), (char)' '))).length != n) continue;
            arrayList.add(fArray);
        }
    }

    protected void loadVertexAttrib(String string, ArrayList<float[]> arrayList, int n) {
        this.loadFloatArrayListFromBinary(string, arrayList, n);
    }
}

