/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import krister.Ess.AudioFilter;

public final class PitchShift
extends AudioFilter {
    public float percent;
    private static final int MAX_FRAME_LENGTH = 8192;
    private float[] gInFIFO = new float[8192];
    private float[] gOutFIFO = new float[8192];
    private float[] gFFTworksp = new float[16384];
    private float[] gLastPhase = new float[4097];
    private float[] gSumPhase = new float[4097];
    private float[] gOutputAccum = new float[16384];
    private float[] gAnaFreq = new float[8192];
    private float[] gAnaMagn = new float[8192];
    private float[] gSynFreq = new float[8192];
    private float[] gSynMagn = new float[8192];
    private int gRover;

    public PitchShift(float f) {
        this.percent = f;
    }

    protected void filter_array(float[] fArray, float[] fArray2, float f, int n, int n2) {
        this.smbPitchShift(this.percent, n, n2, 2048, 4, f, fArray, fArray2);
    }

    void clear_float_array(float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = 0.0f;
        }
    }

    void smbPitchShift(float f, int n, int n2, int n3, int n4, float f2, float[] fArray, float[] fArray2) {
        int n5 = n3 / 2;
        int n6 = n3 / 2;
        int n7 = n3 / n4;
        double d = (double)f2 / (double)n3;
        double d2 = Math.PI * 2 * (double)n7 / (double)n3;
        int n8 = n3 - n7;
        if (this.gRover == 0) {
            this.gRover = n8;
        }
        for (int i = 0; i < n2; ++i) {
            int n9;
            double d3;
            double d4;
            double d5;
            double d6;
            int n10;
            this.gInFIFO[this.gRover] = fArray[i + n];
            fArray2[i + n] = this.gOutFIFO[this.gRover - n8];
            ++this.gRover;
            if (this.gRover < n3) continue;
            this.gRover = n8;
            for (n10 = 0; n10 < n3; ++n10) {
                d6 = -0.5 * Math.cos(Math.PI * 2 * (double)n10 / (double)n3) + 0.5;
                this.gFFTworksp[2 * n10] = (float)((double)this.gInFIFO[n10] * d6);
                this.gFFTworksp[2 * n10 + 1] = 0.0f;
            }
            this.smbFft(this.gFFTworksp, n3, -1L);
            for (n10 = 0; n10 <= n6; ++n10) {
                double d7 = this.gFFTworksp[2 * n10];
                double d8 = this.gFFTworksp[2 * n10 + 1];
                d5 = 2.0 * Math.sqrt(d7 * d7 + d8 * d8);
                d4 = Math.atan2(d8, d7);
                d3 = d4 - (double)this.gLastPhase[n10];
                this.gLastPhase[n10] = (float)d4;
                int n11 = (int)((d3 -= (double)n10 * d2) / Math.PI);
                n11 = n11 >= 0 ? (n11 += n11 & 1) : (n11 -= n11 & 1);
                d3 -= Math.PI * (double)n11;
                d3 = (double)n4 * d3 / (Math.PI * 2);
                d3 = (double)n10 * d + d3 * d;
                this.gAnaMagn[n10] = (float)d5;
                this.gAnaFreq[n10] = (float)d3;
            }
            for (n9 = 0; n9 < n3; ++n9) {
                this.gSynMagn[n9] = 0.0f;
                this.gSynFreq[n9] = 0.0f;
            }
            for (n10 = 0; n10 <= n6; ++n10) {
                int n12 = (int)((float)n10 / f);
                if (n12 > n6) continue;
                int n13 = n10;
                this.gSynMagn[n13] = this.gSynMagn[n13] + this.gAnaMagn[n12];
                this.gSynFreq[n10] = this.gAnaFreq[n12] * f;
            }
            for (n10 = 0; n10 <= n6; ++n10) {
                d5 = this.gSynMagn[n10];
                d3 = this.gSynFreq[n10];
                d3 -= (double)n10 * d;
                d3 /= d;
                d3 = Math.PI * 2 * d3 / (double)n4;
                int n14 = n10;
                this.gSumPhase[n14] = (float)((double)this.gSumPhase[n14] + (d3 += (double)n10 * d2));
                d4 = this.gSumPhase[n10];
                this.gFFTworksp[2 * n10] = (float)(d5 * Math.cos(d4));
                this.gFFTworksp[2 * n10 + 1] = (float)(d5 * Math.sin(d4));
            }
            for (n10 = n3 + 2; n10 < 2 * n3; ++n10) {
                this.gFFTworksp[n10] = 0.0f;
            }
            this.smbFft(this.gFFTworksp, n3, 1L);
            for (n10 = 0; n10 < n3; ++n10) {
                d6 = -0.5 * Math.cos(Math.PI * 2 * (double)n10 / (double)n3) + 0.5;
                int n15 = n10;
                this.gOutputAccum[n15] = (float)((double)this.gOutputAccum[n15] + 2.0 * d6 * (double)this.gFFTworksp[2 * n10] / (double)(n6 * n4));
            }
            for (n10 = 0; n10 < n7; ++n10) {
                this.gOutFIFO[n10] = this.gOutputAccum[n10];
            }
            for (n9 = 0; n9 < n3; ++n9) {
                this.gOutputAccum[n9] = this.gOutputAccum[n7 + n9];
            }
            for (n10 = 0; n10 < n8; ++n10) {
                this.gInFIFO[n10] = this.gInFIFO[n10 + n7];
            }
        }
    }

    void smbFft(float[] fArray, long l, long l2) {
        int n;
        int n2 = 2;
        while ((long)n2 < 2L * l - 2L) {
            int n3 = 2;
            n = 0;
            while ((long)n3 < 2L * l) {
                if ((n2 & n3) != 0) {
                    ++n;
                }
                n <<= 1;
                n3 <<= 1;
            }
            if (n2 < n) {
                int n4 = n2;
                int n5 = n;
                float f = fArray[n4];
                fArray[n4++] = fArray[n5];
                fArray[n5++] = f;
                f = fArray[n4];
                fArray[n4] = fArray[n5];
                fArray[n5] = f;
            }
            n2 += 2;
        }
        int n6 = 0;
        int n7 = 2;
        while ((double)n6 < Math.log(l) / Math.log(2.0)) {
            int n8 = (n7 <<= 1) >> 1;
            float f = 1.0f;
            float f2 = 0.0f;
            float f3 = (float)(Math.PI / (double)(n8 >> 1));
            float f4 = (float)Math.cos(f3);
            float f5 = (float)((double)l2 * Math.sin(f3));
            for (n = 0; n < n8; n += 2) {
                float f6;
                int n9 = n;
                int n10 = n9 + 1;
                int n11 = n9 + n8;
                int n12 = n11 + 1;
                n2 = n;
                while ((long)n2 < 2L * l) {
                    f6 = fArray[n11] * f - fArray[n12] * f2;
                    float f7 = fArray[n11] * f2 + fArray[n12] * f;
                    fArray[n11] = fArray[n9] - f6;
                    fArray[n12] = fArray[n10] - f7;
                    int n13 = n9;
                    fArray[n13] = fArray[n13] + f6;
                    int n14 = n10;
                    fArray[n14] = fArray[n14] + f7;
                    n9 += n7;
                    n10 += n7;
                    n11 += n7;
                    n12 += n7;
                    n2 += n7;
                }
                f6 = f * f4 - f2 * f5;
                f2 = f * f5 + f2 * f4;
                f = f6;
            }
            ++n6;
        }
    }
}

