#include version.txt

varying vec4 diffuse;
varying vec4 ambientGlobal;
varying vec4 ambient;
varying vec3 normal;
varying vec3 lightDir;
varying vec3 halfVector;
varying float dist;
uniform float wave_time;

void main() {
	vec4 ecPos;
	vec3 aux;
	normal = normalize(gl_NormalMatrix * gl_Normal);

	ecPos = gl_ModelViewMatrix * gl_Vertex;
	aux = vec3(gl_LightSource[0].position-ecPos);
	lightDir = normalize(aux);
	dist = length(aux);
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);

	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	ambientGlobal = gl_LightModel.ambient * gl_FrontMaterial.ambient;
		
	vec4 vertex = gl_Vertex;
	
  float amp = 0.25 * 4.0;	  
	float dist = sqrt(pow(vertex.x, 2.0) + pow(vertex.z, 2.0));

	vertex.y += amp * sin(clamp(dist + (wave_time - 50.0), 0.0, 1.575 * 4.0));
	
	gl_Position = gl_ModelViewProjectionMatrix * vertex; 
}