#include version.txt

uniform sampler2D Texture;
varying vec2 texCoord;
uniform float viewportStep;
uniform float contrast;
uniform vec3 color;

void main(void)
{
	vec4 sum;
	sum = texture2D(Texture, texCoord.xy) * -4.0;

	// Top
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, viewportStep)) * 1.0;
	// Bottom
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, -viewportStep)) * 1.0;
	// Left
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep, 0.0)) * 1.0;
	// Right
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep, 0.0)) * 1.0;

	gl_FragColor = vec4(sum.xyz * color.xyz, 1.0) * contrast;
}
