#include Includes.txt

uniform sampler2D source;
uniform sampler2D kernel;
uniform float blur_radius;
uniform float adjustment;
uniform float texture_size;
uniform float brightness;
uniform float contrast;
varying vec2 Texcoord;

void main(void) {
  
  float blur_diameter = (blur_radius * 2.0) + 1.0;
  
  float kernel_step = 1.0 / blur_diameter;
  float kernel_value = 0.0;
  float kernel_sum = 0.0;  
  vec2 kernel_x = vec2(0.0);  
  
  float sample_step = 1.0 / texture_size;
  vec4 sample_sum = vec4(0.0);  
  vec2 sample_x = vec2(Texcoord.x - ((blur_radius + (sample_step / 2.0)) * sample_step), Texcoord.y);
  
  for(int i = 0; i < int(blur_diameter); i += 1) {
    kernel_value = texture2D(kernel, kernel_x).r * adjustment;
    
    sample_sum += brightnessContrast(texture2D(source, sample_x), brightness, contrast) * vec4(kernel_value);  

    kernel_sum += kernel_value;
    
    kernel_x += vec2(kernel_step, 0.0);
    sample_x += vec2(sample_step, 0.0);
  }

  gl_FragColor = (sample_sum / vec4(kernel_sum));
}
