#include version.txt

uniform sampler2D Texture;
varying vec2 texCoord;
uniform float viewportStep;

void main(void)
{
	vec4 sum;
	sum = texture2D(Texture, texCoord.xy);

	// Top Left
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep, viewportStep));

	// Top Center
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, viewportStep));
	
	// Top Right
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep, viewportStep));


	// Center Left	
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep, 0.0));
	
	// Center
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, 0.0));	
	
	// Center Right
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep, 0.0));
		

	// Bottom Left
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep, -viewportStep));		
		
	// Bottom Center
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, -viewportStep));

	// Bottom Right
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep, -viewportStep));		


	gl_FragColor = vec4(sum.xyz, 1.0);
}
