/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Main
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    Player p1;
    Player p2;
    ArrayList<Player> playerList = new ArrayList();
    ArrayList<MapBlock> blockList = new ArrayList();
    ArrayList<Attack> attackList = new ArrayList();
    ArrayList<Item> itemList = new ArrayList();
    private BufferedImage mapImage = new BufferedImage(1251, 700, 2);
    private Image startImage;
    private Image background;
    private int hammerTime;
    private int hammerCounter = this.hammerTime = 2000;
    static final int HAMMER = 0;
    Sound sound = new Sound();
    private boolean anyKeyPressed;
    private boolean gameOver;
    private int winningPlayer = -1;
    private Image p1win;
    private Image p2win;

    public Main() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
    }

    public void start() {
        this.background = new ImageIcon(this.getClass().getResource("bakgrund.png")).getImage();
        this.startImage = new ImageIcon(this.getClass().getResource("startImage.png")).getImage();
        this.p2win = new ImageIcon(this.getClass().getResource("trollWin.png")).getImage();
        this.p1win = new ImageIcon(this.getClass().getResource("aloneWin.png")).getImage();
        this.p1 = new Player(1000.0, 100.0, 0);
        this.p2 = new Player(300.0, 100.0, 1);
        this.playerList.add(this.p1);
        this.playerList.add(this.p2);
        this.blockList.add(new MapBlock(125, 649, 1000, 20));
        this.blockList.add(new MapBlock(225, 500, 150, 20));
        this.blockList.add(new MapBlock(925, 500, 150, 20));
        this.blockList.add(new MapBlock(400, 250, 500, 20));
        while (!this.anyKeyPressed) {
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sound.startMusic();
        while (!this.gameOver) {
            this.checkGameOver();
            this.checkHammer();
            this.moveItems();
            this.itemPlayerCollision();
            this.checkDeadPlayers();
            this.checkPlayersOutOfMap();
            this.updatePlayerAttacking();
            int i = 0;
            while (i < this.playerList.size()) {
                this.playerList.get(i).updateMoveUpDown();
                this.playerList.get(i).moveX();
                this.collision(0);
                this.playerList.get(i).moveY();
                this.collision(1);
                this.collision(2);
                this.playerList.get(i).updateAnimation();
                ++i;
            }
            this.attackCollision();
            this.attackMovement();
            this.repaint();
            try {
                Thread.sleep(8L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sound.stopMusic();
        while (true) {
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void checkGameOver() {
        int i = 0;
        while (i < this.playerList.size()) {
            if (this.playerList.get(i).getLives() <= 0) {
                this.winningPlayer = i;
                this.gameOver = true;
            }
            ++i;
        }
    }

    public void itemPlayerCollision() {
        int i = 0;
        while (i < this.itemList.size()) {
            Item item = this.itemList.get(i);
            item.move();
            int ix = (int)item.getX();
            int iy = (int)item.getY();
            int iw = item.getWidth();
            int ih = item.getHeight();
            int c = 0;
            while (c < this.playerList.size()) {
                int ph;
                int pw;
                int py;
                Player p = this.playerList.get(c);
                int px = (int)p.getX();
                if (this.intersects(ix, iy, iw, ih, px, py = (int)p.getY(), pw = (int)p.getWidth(), ph = (int)p.getHeight())) {
                    item.pickUp(p);
                    this.itemList.remove(i);
                }
                ++c;
            }
            ++i;
        }
    }

    public void moveItems() {
        int i = 0;
        while (i < this.itemList.size()) {
            Item item = this.itemList.get(i);
            int ix = (int)item.getX();
            int iy = (int)item.getY();
            int iw = item.getWidth();
            int ih = item.getHeight();
            int c = 0;
            while (c < this.blockList.size()) {
                int bh;
                int bw;
                int by;
                MapBlock b = this.blockList.get(c);
                int bx = (int)b.getX();
                if (this.intersects(ix, iy, iw, ih, bx, by = (int)b.getY(), bw = (int)b.getWidth(), bh = (int)b.getHeight())) {
                    item.setLanded(true);
                    item.moveBack();
                }
                ++c;
            }
            if (!item.hasLanded()) {
                item.move();
            }
            ++i;
        }
    }

    public void checkHammer() {
        --this.hammerCounter;
        if (this.hammerCounter <= 0) {
            this.hammerCounter = this.hammerTime;
            this.itemList.add(new Item((int)(Math.random() * (double)(Frame.panelWidth - 50)), -50.0, 0));
        }
    }

    public void checkPlayersOutOfMap() {
        int i = 0;
        while (i < this.playerList.size()) {
            if (this.playerList.get(i).getY() > 2000.0) {
                this.playerList.get(i).killPlayer();
            }
            ++i;
        }
    }

    public void attackMovement() {
        int i = 0;
        while (i < this.attackList.size()) {
            this.attackList.get(i).decreaseAttackLength();
            this.attackList.get(i).setPosition();
            if (this.attackList.get(i).shouldBeRemoved()) {
                this.attackList.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void updatePlayerAttacking() {
        int i = 0;
        while (i < this.playerList.size()) {
            this.playerList.get(i).decreaseAttackCooldown();
            this.playerList.get(i).setAttacking(false);
            ++i;
        }
        i = 0;
        while (i < this.attackList.size()) {
            this.attackList.get(i).getPlayer().setAttacking(true);
            ++i;
        }
    }

    public void checkDeadPlayers() {
        int i = 0;
        while (i < this.playerList.size()) {
            if (Math.round(this.playerList.get(i).getHealth()) <= 0L) {
                this.playerList.get(i).decreaseLives();
                this.playerList.get(i).setFullHealth();
                this.playerList.get(i).setX((int)(Math.random() * 600.0 + 300.0));
                this.playerList.get(i).setY(-100);
            }
            ++i;
        }
    }

    public void attackCollision() {
        int i = 0;
        while (i < this.attackList.size()) {
            Attack a = this.attackList.get(i);
            int ax = (int)a.getX();
            int ay = (int)a.getY();
            int aw = a.getWidth();
            int ah = a.getHeight();
            int c = 0;
            while (c < this.playerList.size()) {
                int ph;
                int pw;
                int py;
                Player p = this.playerList.get(c);
                int px = (int)p.getX();
                if (this.intersects(px, py = (int)p.getY(), pw = (int)p.getWidth(), ph = (int)p.getHeight(), ax, ay, aw, ah) && p != this.attackList.get(i).getPlayer()) {
                    if (px > ax) {
                        this.playerList.get(c).getHit(this.attackList.get(i).getHitBack(), this.attackList.get(i).getDamage());
                    } else {
                        this.playerList.get(c).getHit(-this.attackList.get(i).getHitBack(), this.attackList.get(i).getDamage());
                    }
                    a.remove();
                }
                ++c;
            }
            ++i;
        }
    }

    public void collision(int xy) {
        int i = 0;
        while (i < this.playerList.size()) {
            Player p = this.playerList.get(i);
            int px = (int)p.getX();
            int py = (int)p.getY();
            int pw = (int)p.getWidth();
            int ph = (int)p.getHeight();
            if (xy == 2) {
                py += 50;
                px += 5;
                pw -= 10;
                ph -= 49;
            }
            int c = 0;
            while (c < this.blockList.size()) {
                int bh;
                int bw;
                int by;
                MapBlock b = this.blockList.get(c);
                int bx = (int)b.getX();
                if (this.intersects(px, py, pw, ph, bx, by = (int)b.getY(), bw = (int)b.getWidth(), bh = (int)b.getHeight())) {
                    if (xy == 0) {
                        p.collideX();
                    } else if (xy == 1) {
                        p.collideY();
                    } else if (xy == 2) {
                        p.footCollision();
                    }
                }
                ++c;
            }
            this.playerList.get(i).updateOldPos();
            ++i;
        }
    }

    @Override
    public void paint(Graphics g2) {
        if (!this.anyKeyPressed) {
            g2.setColor(new Color(255, 0, 0));
            g2.fillRect(0, 0, Frame.width, Frame.height);
            Graphics g = this.mapImage.getGraphics();
            g.drawImage(this.startImage, 0, 0, null);
            g2.drawImage(this.mapImage, Frame.width / 2 - 622, Frame.height / 2 - 350, null);
        } else if (!this.gameOver) {
            g2.setColor(new Color(131, 219, 226));
            g2.fillRect(0, 0, Frame.width, Frame.height);
            Graphics g = this.mapImage.getGraphics();
            g.setColor(new Color(131, 219, 226));
            g.fillRect(0, 0, Frame.panelWidth, Frame.panelHeight);
            g.drawImage(this.background, 53, 62, null);
            int i = 0;
            while (i < this.playerList.size()) {
                this.playerList.get(i).draw(g);
                ++i;
            }
            i = 0;
            while (i < this.attackList.size()) {
                this.attackList.get(i).draw(g);
                ++i;
            }
            i = 0;
            while (i < this.itemList.size()) {
                this.itemList.get(i).draw(g);
                ++i;
            }
            ((Graphics2D)g2).scale(1.0, 1.0);
            g2.drawImage(this.mapImage, Frame.width / 2 - 622, Frame.height / 2 - 350, null);
        } else {
            g2.setColor(new Color(255, 0, 0));
            g2.fillRect(0, 0, Frame.width, Frame.height);
            Graphics g = this.mapImage.getGraphics();
            if (this.winningPlayer == 0) {
                g.drawImage(this.p1win, 0, 0, null);
            } else if (this.winningPlayer == 1) {
                g.drawImage(this.p2win, 0, 0, null);
            }
            g2.drawImage(this.mapImage, Frame.width / 2 - 622, Frame.height / 2 - 350, null);
        }
    }

    public boolean intersects(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x2 < x1 + w1 && x2 + w2 > x1 && y2 < y1 + h1 && y2 + h2 > y1;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int ay;
        int ax;
        int s;
        int d;
        int ah;
        int aw;
        int d2;
        int ah2;
        int aw2;
        int dfp;
        this.anyKeyPressed = true;
        if (e.getKeyCode() == 87) {
            this.playerList.get(1).jump();
            this.playerList.get(1).setMoveUp(true);
        }
        if (e.getKeyCode() == 65) {
            this.playerList.get(1).setMoveLeft(true);
        }
        if (e.getKeyCode() == 83) {
            this.playerList.get(1).setMoveDown(true);
        }
        if (e.getKeyCode() == 68) {
            this.playerList.get(1).setMoveRight(true);
        }
        if (e.getKeyCode() == 49) {
            dfp = 50;
            aw2 = 50;
            ah2 = 50;
            d2 = 20;
            if (this.playerList.get(1).getAttackCooldown() <= 0) {
                this.attackList.add(new Attack(aw2, ah2, d2, 30, this.playerList.get(1), dfp, 1));
                this.playerList.get(1).setAttackCooldown();
            }
        }
        if (e.getKeyCode() == 51 && this.playerList.get(1).getHammers() > 0) {
            this.playerList.get(1).decreseHammers();
            this.sound.hammaren();
            aw = 50;
            ah = 50;
            d = 50;
            s = this.playerList.get(1).isFacingRight() ? 4 : -4;
            ax = (int)this.playerList.get(1).getX();
            ay = (int)this.playerList.get(1).getY();
            if (this.playerList.get(1).getAttackCooldown() <= 0) {
                this.attackList.add(new Attack(ax, ay, aw, ah, d, 500, this.playerList.get(1), s, true, 2));
                this.playerList.get(1).setAttackCooldown();
            }
        }
        if (e.getKeyCode() == 50) {
            aw = 50;
            ah = 50;
            d = 5;
            s = this.playerList.get(1).isFacingRight() ? 4 : -4;
            ax = (int)this.playerList.get(1).getX();
            ay = (int)this.playerList.get(1).getY();
            if (this.playerList.get(1).getAttackCooldown() <= 0) {
                this.attackList.add(new Attack(ax, ay, aw, ah, d, 70, this.playerList.get(1), s, false, 0));
                this.playerList.get(1).setAttackCooldown();
            }
        }
        if (e.getKeyCode() == 10 && this.playerList.get(0).getHammers() > 0) {
            this.playerList.get(0).decreseHammers();
            this.sound.hammaren();
            aw = 50;
            ah = 50;
            d = 50;
            s = this.playerList.get(0).isFacingRight() ? 4 : -4;
            ax = (int)this.playerList.get(0).getX();
            ay = (int)this.playerList.get(0).getY();
            if (this.playerList.get(0).getAttackCooldown() <= 0) {
                this.attackList.add(new Attack(ax, ay, aw, ah, d, 500, this.playerList.get(0), s, true, 2));
                this.playerList.get(0).setAttackCooldown();
            }
        }
        if (e.getKeyCode() == 16) {
            aw = 50;
            ah = 50;
            d = 5;
            s = this.playerList.get(0).isFacingRight() ? 4 : -4;
            ax = (int)this.playerList.get(0).getX();
            ay = (int)this.playerList.get(0).getY();
            if (this.playerList.get(0).getAttackCooldown() <= 0) {
                this.attackList.add(new Attack(ax, ay, aw, ah, d, 70, this.playerList.get(0), s, false, 0));
                this.playerList.get(0).setAttackCooldown();
            }
        }
        if (e.getKeyCode() == 27) {
            System.exit(0);
        }
        if (e.getKeyCode() == 17) {
            dfp = 50;
            aw2 = 50;
            ah2 = 50;
            d2 = 20;
            if (this.playerList.get(0).getAttackCooldown() <= 0) {
                this.attackList.add(new Attack(aw2, ah2, d2, 30, this.playerList.get(0), dfp, 1));
                this.attackList.get(0).getPlayer().setAttackCooldown();
            }
        }
        if (e.getKeyCode() == 38) {
            this.playerList.get(0).jump();
            this.playerList.get(0).setMoveUp(true);
        }
        if (e.getKeyCode() == 40) {
            this.playerList.get(0).setMoveDown(true);
        }
        if (e.getKeyCode() == 37) {
            this.playerList.get(0).setMoveLeft(true);
        }
        if (e.getKeyCode() == 39) {
            this.playerList.get(0).setMoveRight(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.playerList.get(0).setMoveUp(false);
        }
        if (e.getKeyCode() == 40) {
            this.playerList.get(0).setMoveDown(false);
        }
        if (e.getKeyCode() == 37) {
            this.playerList.get(0).setMoveLeft(false);
        }
        if (e.getKeyCode() == 39) {
            this.playerList.get(0).setMoveRight(false);
        }
        if (e.getKeyCode() == 65) {
            this.playerList.get(1).setMoveLeft(false);
        }
        if (e.getKeyCode() == 68) {
            this.playerList.get(1).setMoveRight(false);
        }
        if (e.getKeyCode() == 87) {
            this.playerList.get(1).setMoveUp(false);
        }
        if (e.getKeyCode() == 83) {
            this.playerList.get(1).setMoveDown(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

