package org.shiftone.jrat.provider.stats.jmx.attributes;

import org.shiftone.jrat.core.MethodKeyAccumulator;

/**
 * @author Jeff Drost
 * @version $Revision: 1.1 $
 */
public class MaxConcurrentThreadsAttributeValue extends AbstractAccumulatorAttributeValue {

	public MaxConcurrentThreadsAttributeValue(MethodKeyAccumulator accumulator) {

		super(accumulator, Integer.class.getName(), "maximum number of threads that concurrent executed the method");
	}

	public Object getValue() {

		return new Integer(accumulator.getMaxConcurrentThreads());
	}
}
