package org.shiftone.jrat.aop.proxy;

import org.shiftone.jrat.api.Command;
import java.lang.reflect.Method;

/**
 * @author $Author: jeffdrost $
 * @version $Revision: 1.4 $
 */
public class ProxyCommand implements Command {

	private final Object target;
	private final Method method;
	private final Object[] args;

	public ProxyCommand(Object target, Method method, Object[] args) {

		this.target = target;
		this.method = method;
		this.args = args;
	}

	public Object execute() throws Throwable {

		return method.invoke(target, args);
	}
}
