/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.newdawn.slick.opengl.ImageIOImageData;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;

public class BufferedImageUtil {
    public static Texture getTexture(String resourceName, BufferedImage resourceImage) throws IOException {
        Texture tex = BufferedImageUtil.getTexture(resourceName, resourceImage, 3553, 32856, 9729, 9729);
        return tex;
    }

    public static Texture getTexture(String resourceName, BufferedImage resourceImage, int filter) throws IOException {
        Texture tex = BufferedImageUtil.getTexture(resourceName, resourceImage, 3553, 32856, filter, filter);
        return tex;
    }

    public static Texture getTexture(String resourceName, BufferedImage resourceimage, int target, int dstPixelFormat, int minFilter, int magFilter) throws IOException {
        ImageIOImageData data = new ImageIOImageData();
        int srcPixelFormat = 0;
        int textureID = InternalTextureLoader.createTextureID();
        TextureImpl texture = new TextureImpl(resourceName, target, textureID);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)target, (int)textureID);
        BufferedImage bufferedImage = resourceimage;
        texture.setWidth(bufferedImage.getWidth());
        texture.setHeight(bufferedImage.getHeight());
        srcPixelFormat = bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407;
        ByteBuffer textureBuffer = data.imageToByteBuffer(bufferedImage, false, false, null);
        texture.setTextureHeight(data.getTexHeight());
        texture.setTextureWidth(data.getTexWidth());
        texture.setAlpha(data.getDepth() == 32);
        if (target == 3553) {
            GL11.glTexParameteri((int)target, (int)10241, (int)minFilter);
            GL11.glTexParameteri((int)target, (int)10240, (int)magFilter);
            if (GLContext.getCapabilities().GL_EXT_texture_mirror_clamp) {
                GL11.glTexParameteri((int)3553, (int)10242, (int)34627);
                GL11.glTexParameteri((int)3553, (int)10243, (int)34627);
            } else {
                GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
                GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            }
        }
        GL11.glTexImage2D((int)target, (int)0, (int)dstPixelFormat, (int)texture.getTextureWidth(), (int)texture.getTextureHeight(), (int)0, (int)srcPixelFormat, (int)5121, (ByteBuffer)textureBuffer);
        return texture;
    }

    private static void copyArea(BufferedImage image, int x, int y, int width, int height, int dx, int dy) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.drawImage((Image)image.getSubimage(x, y, width, height), x + dx, y + dy, null);
    }
}

