/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg.thread;

import java.io.BufferedInputStream;
import java.io.IOException;

public class ProcessThread
extends Thread {
    private Process _process;
    private String[] _commandArray;
    private int _result;
    private int _exitValue;
    private String _output = "";
    private String _error = "";

    public ProcessThread(String[] commandArray) {
        this.setCommandArray(commandArray);
    }

    public void run() {
        block2: {
            try {
                this.setProcess(Runtime.getRuntime().exec(this.getCommandArray()));
                int result = this.getProcess().waitFor();
                this.setResult(result);
                this.setExitValue(this.getProcess().exitValue());
                this.setOutput();
                this.setError();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) break block2;
                e.printStackTrace();
            }
        }
        this.destroy();
    }

    public void destroy() {
        this.destroyProcess();
    }

    public void interrupt() {
        this.destroyProcess();
        super.interrupt();
    }

    public int getResult() {
        return this._result;
    }

    protected void setResult(int result) {
        this._result = result;
    }

    private BufferedInputStream getProcessStream() {
        if (this.getProcess() != null && this.getProcess().getInputStream() != null) {
            return new BufferedInputStream(this.getProcess().getInputStream());
        }
        return null;
    }

    private BufferedInputStream getErrorStream() {
        if (this.getProcess() != null && this.getProcess().getErrorStream() != null) {
            return new BufferedInputStream(this.getProcess().getErrorStream());
        }
        return null;
    }

    public String getProcessOutput() throws IOException {
        return this.getBufferedInput(this.getProcessStream());
    }

    public String getErrorOutput() throws IOException {
        return this.getBufferedInput(this.getErrorStream());
    }

    private void setOutput() throws IOException {
        this._output = this.getBufferedInput(this.getProcessStream());
    }

    private void setError() throws IOException {
        this._error = this.getBufferedInput(this.getErrorStream());
    }

    private String getBufferedInput(BufferedInputStream in) throws IOException {
        if (in == null) {
            return "";
        }
        int available = in.available();
        String s = "";
        if (available > 0) {
            byte[] b = new byte[available];
            in.read(b);
            s = new String(b);
        }
        return s;
    }

    public String[] getCommandArray() {
        return this._commandArray;
    }

    public Process getProcess() {
        return this._process;
    }

    protected void setCommandArray(String[] strings) {
        this._commandArray = strings;
    }

    protected void setProcess(Process process) {
        this._process = process;
    }

    protected String getOutput() {
        return this._output;
    }

    protected String getError() {
        return this._error;
    }

    private void destroyProcess() {
        if (this.getProcess() != null) {
            this.getProcess().destroy();
        }
    }

    public int getExitValue() {
        return this._exitValue;
    }

    public void setExitValue(int i) {
        this._exitValue = i;
    }
}

