/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.sourceforge.jogg.JOgg;
import org.sourceforge.jogg.JOggProperties;
import org.sourceforge.jogg.SongData;
import org.sourceforge.jogg.event.ThreadEvent;
import org.sourceforge.jogg.event.ThreadListener;
import org.sourceforge.jogg.interpreter.MP3OutputInterpreter;
import org.sourceforge.jogg.interpreter.OggOutputInterpreter;
import org.sourceforge.jogg.layout.GBLayout;
import org.sourceforge.jogg.thread.EncoderThread;
import org.sourceforge.jogg.thread.MP3Thread;
import org.sourceforge.jogg.thread.OggThread;

public class EncoderWindow
extends JDialog
implements ThreadListener {
    private File _output;
    private String _wavDir;
    private SongData[] _selected;
    private JTextArea _processOutput = new JTextArea(20, 40);
    private JButton _start = new JButton("Start");
    private JButton _cancel = new JButton("Cancel");
    private JButton _stop = new JButton("Stop");
    private Process _process;
    private JOggProperties _properties;
    private int _counter = 0;
    private JProgressBar _progress = new JProgressBar(0, 0, 100);
    private JProgressBar _totalProgress = new JProgressBar(0);
    private JTextField _value = new JTextField(6);
    private OggOutputInterpreter _oggInterpreter = new OggOutputInterpreter();
    private MP3OutputInterpreter _mp3Interpreter = new MP3OutputInterpreter();
    private JTextField _track = new JTextField(10);

    public EncoderWindow(JFrame frame, File output, String wavDir, SongData[] selected) {
        super(frame, "Encoding...", true);
        this._output = output;
        this._selected = selected;
        this._properties = JOggProperties.getInstance();
        this._wavDir = wavDir;
        this.init();
        this.pack();
    }

    public void dispose() {
        if (this._process != null) {
            this._process.destroy();
        }
        super.dispose();
    }

    public void show() {
        this.encode();
        super.show();
    }

    public void threadEventPerformed(ThreadEvent e) {
        if (e.isStopped()) {
            this._start.setEnabled(true);
        } else if (e.isStarted()) {
            this._start.setEnabled(false);
        } else if (e.isOutput()) {
            this.setOutput(e.getMessage());
        } else if (e.isFileEncoded()) {
            this.incrementCounter();
        }
    }

    private void incrementCounter() {
        ++this._counter;
        this._totalProgress.setValue(this._counter);
        this.showTrack();
    }

    private int getCounter() {
        return this._counter;
    }

    private void encode() {
        try {
            EncoderThread thread = this.getEncoderThread();
            this._stop.addActionListener(thread);
            this._cancel.addActionListener(thread);
            thread.addThreadListener(this);
            thread.start();
            this.showTrack();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Exception:", 0);
        }
    }

    private EncoderThread getEncoderThread() {
        EncoderThread thread = null;
        if (this._properties.isOggEncoding()) {
            thread = new OggThread(this._selected);
        } else if (this._properties.isMP3Encoding()) {
            thread = new MP3Thread(this._selected);
        }
        return thread;
    }

    private void showTrack() {
        if (this.getCounter() < this._selected.length) {
            SongData data = this._selected[this.getCounter()];
            this._track.setText(data.getFile());
        }
    }

    private void setOutput(String text) {
        if (this._properties.isOggEncoding()) {
            this.showOggOutput(text);
        } else {
            this.showMP3Output(text);
        }
    }

    private void showMP3Output(String text) {
        this._mp3Interpreter.setOutput(text);
        if (this._mp3Interpreter.isStart()) {
            this._processOutput.append(text);
            this._value.setText("");
        } else if (this._mp3Interpreter.isEnd()) {
            this._processOutput.append("Result: " + this._mp3Interpreter.getProcessResult() + JOgg.NEW_LINE);
            this._processOutput.append("Exit: " + this._mp3Interpreter.getProcessExit() + JOgg.NEW_LINE);
        } else {
            this._value.setText(this._mp3Interpreter.getValue());
        }
    }

    private void showOggOutput(String text) {
        this._oggInterpreter.setOutput(text);
        if (this._oggInterpreter.isStart()) {
            this._processOutput.append(text);
            this._progress.setValue(0);
            this._value.setText("");
        } else if (this._oggInterpreter.isEnd()) {
            this._processOutput.append("Result: " + this._oggInterpreter.getProcessResult() + " ");
            this._processOutput.append("Exit: " + this._oggInterpreter.getProcessExit() + JOgg.NEW_LINE);
        } else {
            this._progress.setValue((int)this._oggInterpreter.getPercentComplete());
            this._value.setText(this._oggInterpreter.getTimeRemaining());
        }
    }

    private void init() {
        this._cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncoderWindow.this.dispose();
            }
        });
        this._cancel.setMnemonic('C');
        this._start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncoderWindow.this.encode();
            }
        });
        this._start.setMnemonic('S');
        this._stop.setMnemonic('t');
        this._totalProgress.setMinimum(0);
        this._totalProgress.setMaximum(this._selected.length);
        this._value.setEditable(false);
        this._value.setBorder(null);
        this._track.setEditable(false);
        this._track.setBorder(null);
        this.layoutThis();
    }

    private void layoutThis() {
        GBLayout layout = new GBLayout(this.getContentPane());
        layout.addComponent((Component)new JScrollPane(this._processOutput), layout.getDimensions(2, 1), 10, true);
        layout.addComponent((Component)this.getProgressPanel(), layout.getDimensions(2, 1), 10, true);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new BevelBorder(0));
        buttonPanel.add(this._start);
        buttonPanel.add(this._stop);
        buttonPanel.add(this._cancel);
        layout.addComponent((Component)buttonPanel, layout.getDimensions(2, 1), 10, true);
    }

    private JPanel getProgressPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(0));
        GBLayout layout = new GBLayout(panel);
        layout.addComponent((Component)new JLabel("Overall progress:"), 13);
        layout.addComponent((Component)this._totalProgress, 17, true);
        layout.addComponent((Component)new JLabel("Ripping track:"), 13);
        layout.addComponent((Component)this._track, 17, true);
        if (this._properties.isOggEncoding()) {
            layout.addComponent((Component)new JLabel("Current process:"), 13);
            layout.addComponent((Component)this._progress, 17, true);
            layout.addComponent((Component)new JLabel("Time Remaining:"), 13);
        } else if (this._properties.isMP3Encoding()) {
            layout.addComponent((Component)new JLabel("Progress:"), 13);
        }
        layout.addComponent((Component)this._value, 17, true);
        return panel;
    }
}

