Player@ cPlayer(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<Player>(s);
}
class Player : Scripted, Actor
{
	Asset @asset;
	Peer @myPeer;
	
	int health;
	
	float speed;
	array<InputData@> inputsToProcess;
	Timer inputProcessTimer;
	
	void SetAsset(Asset@ with)
	{
		@asset = @with;
		asset.SetLDamping(3.0f);
		asset.SetADamping(18.0f);
		speed = 3.0f;
		health = 100;
	}
	
	void ProcessInput()
	{
		//if (inputsToProcess[0].miliseconds / 6 > inputProcessTimer.GetElapsedTime())
		if (inputProcessTimer.GetElapsedTime() >= 50)
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_CORRECTION));
			vec2 arrivedPos = asset.GetPosition();
			stream.WriteCompressed(inputsToProcess[0].id);
			stream.Write(arrivedPos.x);
			stream.Write(arrivedPos.y);
			// Try - Changing the reliabilty.
			stream.Send(myPeer.guid, PP::HIGH_PRIORITY, PR::UNRELIABLE, 2, false);
			inputsToProcess.removeAt(0);
			//asset.SetVelocity(0, 0);
			inputProcessTimer.Reset();
		}
		else
		{
			print("\n");
			print(inputsToProcess[0].direction.x);
			print("-");
			print(inputsToProcess[0].direction.y);
			asset.SetVelocity(inputsToProcess[0].direction.x * speed, inputsToProcess[0].direction.y * speed);
		}
	}
	void Update()
	{
		if (inputsToProcess.length() > 0)
			ProcessInput();
		else
			inputProcessTimer.Reset();
	}
}

void PlayerInput(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	InputData inputData;
	
	bit.IgnoreBytes(1);
	bit.ReadCompressed(inputData.id);
	bit.ReadCompressed(inputData.velx);
	bit.ReadCompressed(inputData.vely);
	bit.Read(inputData.position.x);
	bit.Read(inputData.position.y);
	bit.ReadCompressed(inputData.miliseconds);
	
	vec2 velocity(0,0);
	velocity.x = inputData.velx;
	velocity.y = inputData.vely;
		
	velocity.Normalize();
	inputData.direction = velocity;
	
	game.GetPeerByGUID(guid).ProcessInputData(inputData);
}

class InputData
{
	int8 velx;
	int8 vely;
	vec2 direction;		// Normalized, so that it's not calculated over and over again
	
	uint8 id;
	
	vec2 position;		// This is the beginning position or the arrived position after processing the input before this.
	uint miliseconds;	// The duration of the processing of the input before this.
	
	InputData()
	{
		/*up = false;
		down = false;
		left = false;
		right = false;*/
		velx = 0;
		vely = 0;
		
		miliseconds = 0;
		
	}
}