Player@ cPlayer(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<Player>(s);
}

class Player : Scripted, Actor
{
	Asset @asset;
	Peer @myPeer;
	
	float speed;
	
	array<InputData@> inputsToProcess;
	Timer inputProcessTimer;
	int health;
	
	uint timeDifference;
	uint lastTime;
	
	void SetAsset(Asset@ with)
	{
		@asset = @with;
		asset.SetLDamping(3.0f);
		asset.SetADamping(18.0f);
		speed = 9.0f;
		timeDifference = 0;
		health = 100;
	}
	
	void ProcessInput()
	{
		if (inputsToProcess[0].miliseconds / 6 < inputProcessTimer.GetElapsedTime())
		{
			vec2 posDiff = asset.GetPosition() - inputsToProcess[0].positionArrived;
			if (posDiff.Length() < 0.2f)
			{
				asset.SetPosition(inputsToProcess[0].positionArrived);
			}
			if(posDiff.Length() > 0.2f)
			{
				BitStream stream;
				stream.Write(uint8(NetworkMessages::ID_PLAYER_UPDATE));
				stream.Write(myPeer.guid);
				stream.Write(asset.GetPosition().x);
				stream.Write(asset.GetPosition().y);
				stream.Send(myPeer.guid, PP::HIGH_PRIORITY, PR::RELIABLE, 2, false);
			}
			//timeDifference += keyboardInputTimer.GetElapsedTime() - inputsToProcess[0].miliseconds;
			//print(inputsToProcess[0].miliseconds);
			//print("-");
			//print(keyboardInputTimer.GetElapsedTime());
			//print("-");
			//print(timeDifference);
			//print("\n");
			//else
			//asset.SetPosition(inputsToProcess[0].positionArrived);
			//print(inputsToProcess.length());
			inputsToProcess.removeAt(0);
			inputProcessTimer.Reset();
			asset.SetVelocity(0,0);
			if (inputsToProcess.length() > 2)
			{
			while (inputsToProcess.length() > 2) {
			inputsToProcess.removeAt(inputsToProcess.length() - 1); 
			//print("Deleting.\n");
			}
			}
			//lastTime = keyboardInputTimer.GetElapsedTime();
		}
		if (inputsToProcess.length() > 0)
		asset.SetVelocity(inputsToProcess[0].direction.x * speed, inputsToProcess[0].direction.y * speed);
	}
	void Update()
	{
		if (inputsToProcess.length() > 0)
		{
			ProcessInput();
		}
		else
		inputProcessTimer.Reset();
		
if (asset.GetPosition().LengthSq() > 200 * 200)
		{
			vec2 pos = asset.GetPosition();
			pos *=  1 / asset.GetPosition().Length();
			pos *= 200.0f;
			asset.SetPosition(pos);
			}
	}
}