#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec3 XAxis;
uniform vec3 YAxis;
uniform vec4 Sparks; // min angle, color multiplier, radius, offset

varying in vec3 gs_normal[];
//varying in vec2 gs_uv[];

varying out vec3 wpos;
varying out vec3 color;
varying out vec2 uv;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	color = lit_color; \
	wpos = vec3(gl_ModelViewMatrix * vec4(VTX, 1.0)); \
	gl_Position = gl_ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()


void main()
{
	vec3 pos = gl_PositionIn[0].xyz;
	float NdotV = dot(normalize(gs_normal[0]), vec3(0.0, 0.0, 1.0));
	if ( NdotV > Sparks.x )
	{
		float k = (NdotV - Sparks.x)*Sparks.y;
		vec3 lit_color = vec3(k);
		float radius = k*Sparks.z;
		vec3 a = pos + (XAxis + YAxis)*radius;
		vec3 b = pos + (YAxis - XAxis)*radius;
		vec3 c = pos + (-XAxis - YAxis)*radius;
		vec3 d = pos + (XAxis - YAxis)*radius;
		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));
		EndPrimitive();
	}
}
