#version 120

attribute vec3 POSITION;
attribute vec3 NORMAL;
attribute vec2 TEXCOORD;
uniform float NormalOffset;

varying vec3 light_pos; //x,y,z,radius
varying vec2 uv;

void main()
{
	vec3 pos = POSITION + NORMAL*NormalOffset;
	light_pos = vec3(gl_ModelViewMatrix * vec4(pos, 1.0));

	uv = TEXCOORD;

	// normal = gl_NormalMatrix * NORMAL;

	gl_Position = gl_ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
