#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec3  Spline[3];
uniform float Time;

varying in vec3 gs_normal[];
varying in vec2 gs_uv[];

varying out vec2 pos_zw;
varying out vec3 normal;
varying out vec2 uv;

#include <matrix_include.vert>

#define PI_OVER_TWO 1.5707963267948966192313216916398

#define EMIT_VERTEX(VTX, NORM, UV) \
	uv = UV; \
	normal = gl_NormalMatrix * NORM; \
	proj_pos = gl_ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	pos_zw = proj_pos.zw; \
	gl_Position = proj_pos; \
	EmitVertex()

#if 1
vec3 evaluate_spline(in float t)
{
	// catmul-rom

	//const float k = 1.0;
	const float k = 0.125;
	if ( t < 1.0 )
	{
		float t2 = t*t;
		float t3 = t2*t;
		float h2 = 3.0*t2 - t3 - t3;
		float h1 = 1.0 - h2;
		float h4 = t3 - t2;
		float h3 = h4 - t2 + t;
		vec3 outgoing = (Spline[2] - Spline[0])*k;
		vec3 incomming = -(Spline[2] - Spline[0])*k;
		return h1*Spline[0] + h2*Spline[1] + h3*outgoing + h4*incomming;
	}
	else
	{
		float t0 = t - 1.0;
		float t2 = t0*t0;
		float t3 = t2*t0;
		float h2 = 3.0*t2 - t3 - t3;
		float h1 = 1.0 - h2;
		float h4 = t3 - t2;
		float h3 = h4 - t2 + t0;
		vec3 outgoing = (Spline[2] - Spline[0])*k;
		vec3 incomming = -(Spline[2] - Spline[0])*k;
		return h1*Spline[1] + h2*Spline[2] + h3*outgoing + h4*incomming;
	}
}
#else
vec3 evaluate_spline(in float t)
{
	// cosine interpolation seems to do the trick for most curves
	if ( t < 1.0 )
	{
		float k2 = cos((1.0 - t)*PI_OVER_TWO);
		return Spline[0] + (Spline[1] - Spline[0])*k2;
	}
	else
	{
		float k2 = cos((2.0 - t)*PI_OVER_TWO);
		return Spline[1] + (Spline[2] - Spline[1])*k2;
	}
}
#endif

void main()
{
	vec3 center = (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0;
	float len = length(center)*0.25;
	float t = max(Time - len, 0.0);
	if ( t < 2.0 )
	{
		vec3 spos = evaluate_spline(t);
		float k = pow(t*0.5, 8.0);
		vec3 tpos = mix(spos, center, k);

		float k2 = (2.0 - t);
		float angle = k2*PI_OVER_TWO*16.0;
		tpos.x += sin(angle) * sin(angle*0.9) * k2;
		tpos.z += cos(angle*0.7) * cos(angle*0.6) * k2;
		tpos.y += cos(PI_OVER_TWO+angle*0.5) * cos(PI_OVER_TWO+angle*0.4) * k2;

		mat3 mr;
		rotate_around_axis(normalize(center), (2.0 - t)*PI_OVER_TWO*4.0, mr);

		vec4 proj_pos;
		for (int i=0; i < 3; i++)
		{
			vec3 v = mr*(gl_PositionIn[i].xyz - center) + tpos;
			vec3 n = mr * gs_normal[i];
			EMIT_VERTEX(v, n, gs_uv[i]);
		}
		EndPrimitive();
	}
	else
	{
		vec4 proj_pos;
		for (int i=0; i < 3; i++)
		{
			EMIT_VERTEX(gl_PositionIn[i].xyz, gs_normal[i], gs_uv[i]);
		}
		EndPrimitive();
	}
}
