#version 120
#extension GL_EXT_geometry_shader4 : enable

varying in vec3 gs_color[];

varying out vec3 light_dir;
varying out vec3 color;

#define EMIT(VTX) \
	light_dir = dir; \
	color = gs_color[0]; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	// it is assumed that the input vertex is formatted as vec4(x,y,z,intensity)
	vec3 dir = normalize(gl_PositionIn[0].xyz);
	
	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));
	
	EndPrimitive();
}
