
local tex_ppm, tex_width, tex_height

-- this is done only once, when the demo starts
function effect1_load() 
	--print("effect1_load")
--	tex_ppm, tex_width, tex_height = load_texture('ilmari.ppm')
end

-- done just before first _paint
function effect1_init(time)
	--print("effect1_init "..time)
end

local function set_material()
	glEnable(GL_LIGHT0)
	glLightfv(GL_LIGHT0, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
	glLightfv(GL_LIGHT0, GL_DIFFUSE, {1, 1, 1, 1})
	glLightfv(GL_LIGHT0, GL_POSITION, {0.0, 1.0, 0.0, 0.0})

	glEnable(GL_LIGHT1)
	glLightfv(GL_LIGHT1, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
	glLightfv(GL_LIGHT1, GL_DIFFUSE, {1, 1, 1, 1})
	glLightfv(GL_LIGHT1, GL_POSITION, {1.0, 0.0, 1.0, 0.0})

	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
	glFrontFace(GL_CW)
end

local function glutStrokeString(font, str)
        for i = 1, string.len(str) do
                glutStrokeCharacter(font, string.byte(str, i))
        end
end


-- time = milliseconds in song
function effect1_paint(time, params)
        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                time = time + params.delta
        end


	spectrum = engine_spectrum();

	col = 0;
	for i = 0, 50 do
                col = col + spectrum[i];
        end

	
	glMatrixMode(GL_MODELVIEW)
	local angle = 0
	local angle2 = 0
	
	angle = (math.cos(time*0.001)+math.sin(time*0.002))*15
	angle2 = (math.sin(time*0.0015)+math.cos(time*0.0025))*14
	set_material()
	
	glPushMatrix()
	glTranslated(0,0,-5)
	local objr = time*0.01
	glRotated(90,0,1,0)
	glEnable(GL_LIGHTING)
	
	glEnable(GL_DEPTH_TEST)
	glEnable(GL_NORMALIZE)
--	glTexImage2D(GL_TEXTURE_2D, 0, 3, tex_width, tex_height, 0, GL_RGB, GL_UNSIGNED_BYTE, tex_ppm:ptr())
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_DECAL)
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL)
	glEnable(GL_BLEND)
	glEnable(GL_MULTISAMPLE)
	local i = 0
	
	for i = 0, 360 do
		local rot = math.cos(i+time*0.00001)*360
		glRotated(rot,1,0,0)

		local fade = 0

		if time-params.delta >= 3000 then
			fade = ((time-params.delta)-3000)*0.0002
		end

		local colr = 0.4+(math.sin(i*0.001+time*0.001)*0.2)-fade
		local colg = 0.4+(math.cos(i*0.0005+time*0.0015)*0.2)-fade
		local colb = 0.4+(math.sin(i*0.0007+time*0.002)*0.2)-fade

		if colr <= 0 then colr = 0
		end
		if colg <= 0 then colg = 0
		end
		if colb <= 0 then colb = 0
		end

		glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE,  {colr, colg, colb, 0.7+math.cos(i*0.6+time*0.01)*1})
		glMaterialfv(GL_BACK, GL_AMBIENT_AND_DIFFUSE,  {colr, colg, colb, 0.8+math.sin(i*0.6+time*0.01)*1})
		glBlendFunc(GL_SRC_ALPHA, GL_ONE)

		glBegin(GL_TRIANGLE_STRIP)
				local coordx = math.cos(time*0.0001)+math.sin(time*0.0003)*1
				local coordy = math.sin(time*0.00015)+math.cos(time*0.0001+(col*0.1))*3
				local coordz = math.sin(time*0.00014+i+math.cos(i*0.001+time*0.0001))*1
				glVertex3d(-1-coordx, -1+coordy, 0)
				glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE,  {colr, colb, colg, 0.0})
				glMaterialfv(GL_BACK, GL_AMBIENT_AND_DIFFUSE,  {colr, colb, colg, 0.02})
				glVertex3d(-1-coordy, 1+coordx*coordy, 0)
				glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE,  {colg, colr, colb, 0.0})
				glMaterialfv(GL_BACK, GL_AMBIENT_AND_DIFFUSE,  {colg, colr, colb, 0.02})
				glVertex3d(1-coordz, 1+coordz, coordx)
		glEnd()
	end
	glDisable(GL_MULTISAMPLE)
	
	glDisable(GL_LIGHTING)
	glPopMatrix()

        glDisable(GL_BLEND)
        glDisable(GL_TEXTURE_2D)
        glMatrixMode(GL_PROJECTION)
        glPushMatrix()
		glLoadIdentity()
		glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -3, 3)
		local texcol = 1.0-time*0.00004
		glColor3d(texcol,texcol,texcol)
		glTranslated(0,6,3)
		glScaled(0.2,0.2,0.2)
		name = 'Bilotrip'
		charri = ''
		if time < 17300 then charri = string.char(math.random(92,120))
		end
		glutStrokeString(GLUT_STROKE_MONO_ROMAN, string.sub(name,0,(time-12000)*0.0015) .. charri)
	glPopMatrix()
	
end

-- called after last _paint
function effect1_deinit()
	--print("effect1_deinit")
end

function effect1_unload()
	--print("effect1_unload")
end
