#version 330 core

uniform sampler2D bumpmap;
uniform sampler2D diffuse;
uniform sampler2D flow;
uniform sampler2D overlay;
uniform float time;
uniform vec2 viewport;

in vec3 normal;
in vec2 uv;
in vec2 offset;

layout (location = 0) out vec4 frag_color;

void main()
{
	const vec3 diff = vec3(53.f/255.0, 62.0/255.0, 93.0/255.0);
	const vec3 refr = vec3(53.f/255.0, 62.0/255.0, 93.0/255.0);
	const vec3 refl = vec3(83.f/255.0, 92.0/255.0, 113.0/255.0);
	const vec3 ld = vec3(0.0, 0.0, 1.0);
	//vec3 ld = normalize(vec3(1.0, 1.0, 1.0));

	// pseudo water flow
	vec3 f = texture(flow, uv*(1.0/64.0)).rgb;
	vec2 flow_uv = f.rg*2.0 - vec2(1.0);
	float flow_offset0 = mod(time, 1.0);
	float flow_offset1 = mod(time + 0.5, 1.0);
	float cycle_offset = f.b;

	float phase0 = cycle_offset*0.5 + flow_offset0;
	float phase1 = cycle_offset*0.5 + flow_offset1;

	// make waves
	vec3 n0 = texture(bumpmap, uv+flow_uv*phase0).rgb*2.0 - vec3(1.0);
	vec3 n1 = texture(bumpmap, uv+flow_uv*phase1).rgb*2.0 - vec3(1.0);
	vec3 n2 = texture(bumpmap, uv*8.0+offset).rgb*2.0 - vec3(1.0);
	float k = abs( 0.5 - flow_offset0 ) / 0.5;
	vec3 n = mix(n0, n1, k);
	n = normalize( mix(normal, normalize(n + n2*0.25), 0.5) );

	// fake lighting
	float lit = pow(max(dot(n, ld), 0.0), 8.0);

	vec3 r = normalize(refract(vec3(0.0,0.0,-1.0), n, 0.33));
	float rf = pow(max(dot(r, ld), 0.0), 1.0);

	vec3 r2 = normalize( reflect(vec3(0.0,0.0,-1.0), n) );
	float rf2 = pow(max(dot(r2, ld), 0.0), 32.0);

	vec3 water = diff*lit + refr*rf + refl*rf2;

	vec3 r3 = reflect(vec3(0.0, 0.0, 1.0), n);
	vec2 refr_uv = r3.xz*(1.0/16.0);
	vec4 olay = textureLod(overlay, gl_FragCoord.xy*viewport - refr_uv*0.5, 1.0);
	float alpha = texture(overlay, gl_FragCoord.xy*viewport).a;

	vec3 grnd = texture(diffuse, uv*2.0 + refr_uv).rgb*0.125 + olay.rgb*0.25;
	//vec3 grnd = (texture(diffuse, uv*2.0 + refr_uv).rgb + olay.rgb*olay.a)*0.125;
	//vec3 grnd = olay.rgb;

	frag_color.rgb = grnd + water;
	frag_color.a = (lit + rf + rf2)*(1.0 - alpha*0.8);
}
