#version 330 core

uniform sampler2D diffuse;
uniform sampler2D bumpmap;
uniform sampler2D noise;
uniform vec2 viewport;

in vec4 ec_pos;
in vec2 uv;
in vec4 normal;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <tangentspace_include.frag>

void main()
{
	//vec4 diff = texture(diffuse, uv) * (texture(noise, (ec_pos.xy + ec_pos.zz)*5.25).r);
	vec4 diff = texture(diffuse, uv);
	if ( diff.a < 0.01 ) discard;

	float alpha = (smoothstep(0.0, 0.1, ec_pos.w));
	//diff.a *= texture(noise, uv*0.05 + ec_pos.xy*1.0).r * normal.a * alpha;
	diff.a *= texture(noise, ec_pos.xy*3.0).r * normal.a * alpha;
	diffuse_specular.rgb = diff.rgb;
	diffuse_specular.a = diff.a;

	vec3 t, b;
	per_fragment_tangent_space(ec_pos.xyz, uv, t, b);

	vec3 bump = normalize(texture2D(bumpmap, uv).xyz*2.0 - vec3(1.0));
	
	mat3 mr = mat3(t, b, normal.rgb);
	normal_depth.rgb = normalize(mr * bump)*diff.a;
	//normal_depth.a = diff.a;//*0.25;
	normal_depth.a = diff.a*(1.0 - smoothstep(0.0, 1.0, ec_pos.w));
}
