#version 330 core

uniform sampler2D normal_depth;
uniform sampler2D particle;
uniform sampler2D lut;

uniform vec2 viewport;

in vec3 wpos;
in vec3 uv_alpha;

layout (location = 0) out vec4 frag_color;

#include <gbuffer_include.frag>

void main()
{
	vec4 p = texture(particle, gl_PointCoord).rrrr;
	if ( p.a < 0.1 ) discard;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = uv_alpha.z * clamp((wpos.z - pos.z)*2.0, 0.0, 1.0);
	frag_color = p*vec4(texture(lut, uv_alpha.xy).rgb, 1.0)*alpha;
}
