#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec3 ec_pos;
out vec2 pos_zw;

#define EMIT_VERTEX(VTX, EYE) \
	ec_pos = EYE; \
	pos_zw = VTX.zw; \
	gl_Position = VTX; \
	EmitVertex()

vec3 tetrahedron_vertices[4] = vec3[](
	vec3( 1.0,  1.0,  1.0),
	vec3(-1.0, -1.0,  1.0),
	vec3(-1.0,  1.0, -1.0),
	vec3( 1.0, -1.0, -1.0)
);

layout(points) in;
layout(triangle_strip, max_vertices=6) out;

void main()
{
	if ( gs_params[0].x <= 0.0 ) return;

	vec3 center = gl_in[0].gl_Position.xyz;
	float radius = gs_params[0].x;

	vec4 vertices[4];
	vec3 ec_eye[4];
	for (int i=0; i < 4; i++)
	{
		vec4 pos = vec4(center + tetrahedron_vertices[i]*radius, 1.0);
		ec_eye[i] = vec3(ModelViewMatrix * pos);
		vertices[i] = ModelViewProjectionMatrix * pos;
	}

	EMIT_VERTEX(vertices[0], ec_eye[0]);
	EMIT_VERTEX(vertices[1], ec_eye[1]);
	EMIT_VERTEX(vertices[2], ec_eye[2]);
	EMIT_VERTEX(vertices[3], ec_eye[3]);
	EMIT_VERTEX(vertices[0], ec_eye[0]);
	EMIT_VERTEX(vertices[1], ec_eye[1]);
	EndPrimitive();
}

