#version 330 core

uniform mat4 ProjectionMatrix;

uniform vec3 XAxis;
uniform vec3 YAxis;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec3 wpos;
out vec3 params; // alpha, radius, energy
out vec2 uv;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	params = out_params; \
	gl_Position = ProjectionMatrix * vec4(VTX, 1.0); \
	wpos = VTX; \
	EmitVertex()

void main()
{
	vec3 pos = gl_in[0].gl_Position.xyz;
	float radius = gs_params[0].x;

	if ( radius > 0.0 )
	{
		float dist = dot(vec3(0.0, 0.0, -1.0), pos) - 1.0;
		vec3 out_params;
		out_params.x = smoothstep(0.0, 1.0, dist);
		out_params.y = gs_params[0].x;
		out_params.z = gs_params[0].y;

		vec3 a = pos + (XAxis + YAxis)*radius;
		vec3 b = pos + (YAxis - XAxis)*radius;
		vec3 c = pos + (-XAxis - YAxis)*radius;
		vec3 d = pos + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
