#version 330 core

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec4 light_pos;
in vec3 color;
in vec3 cam_dir;

layout (location = 0) out vec4 frag_color;

#include <gbuffer_include.frag>

float point_light_vol(in vec3 camera_dir, in vec3 epos, in vec3 light_pos, in float light_radius)
{
	vec3 dir = vec3(0.0) - light_pos
	float b = dot(dir, ray_dir);
	float c = dot(dst, dst) - light_radius*light_radius;
	float d = b*b - c;
	if ( d > 0.0 )
	{
		vec3 pt0 = dir*(-b - sqrt(d));
		vec3 pt1 = dir*(-b + sqrt(d));
		float d = distance(epos, light_pos);
		// check if epos is inside the sphere
		if ( d < light_radius )
		{
			return 1.0 - (distance(pt0, epos) / (sphere_radius*2.0));
		}
		else
		{
			return 1.0 - (distance(pt0, pt1) / (sphere_radius*2.0));
		}
	}
	else
	{
		// no light "volume" if there was no intersection
		return 0.0;
	}
}

void main()
{
	const float SPECULAR_POWER = 8.0;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv_pos);
	vec4 nd = texture(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);

	vec3 light_dir = light_pos.xyz - pos;
	float len = length(light_dir);
	if ( len > light_pos.w ) discard;

	light_dir = normalize( light_dir );

	vec3 normal = normalize(nd.xyz);
	float NdotL = dot(normal, light_dir);
	if ( NdotL <= 0.0 ) discard;

	// should we add some noise to the "volume"
	vec3 camera_dir = normalize(cam_dir);
	float vol = point_light_vol(camera_dir, pos, light_pos.xyz, light_pos.w);

	float atten = 1.0 - (len / light_pos.w);
	vec3 half_vector = normalize(reflect(normalize(pos), light_dir));
	float NdotHV = max(dot(normal, half_vector), 0.0)*NdotL;

	vec3 lit = color*ds.rgb*NdotL + color*ds.a*pow(NdotHV, SPECULAR_POWER);
	//frag_color = vec4(lit*atten, NdotL*atten);

	// blend between the lit color and the base color
	frag_color = vec4(mix(lit, color, vol)*atten, NdotL*atten);
}
