#version 330 core

uniform mat4 ProjectionMatrix;

uniform vec3 XAxis;
uniform vec3 YAxis;

in vec3 gs_light_params[1]; // radius
in vec3 gs_light_color[1];

out vec3 wpos;
out vec3 color;
out vec2 uv;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	color = lc; \
	gl_Position = ProjectionMatrix * vec4(VTX, 1.0); \
	wpos = VTX; \
	EmitVertex()

void main()
{
	vec3 lc = gs_light_color[0];
	vec3 pos = gl_in[0].gl_Position.xyz;
	float radius = gs_light_params[0].x*(1.0/16.0);

	float dist = dot(vec3(0.0, 0.0, -1.0), pos) - 1.0;
	lc *= smoothstep(0.0, 1.0, dist);

	vec3 a = pos + (XAxis + YAxis)*radius;
	vec3 b = pos + (YAxis - XAxis)*radius;
	vec3 c = pos + (-XAxis - YAxis)*radius;
	vec3 d = pos + (XAxis - YAxis)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
