
//
// Lens Distortion Filter
// by zeroshift
//

// Projection View Model Matrix
float4x4	gphProjectionModelViewMatrix;

// Pixel shader textures
sampler		gphTexture0:register(s0);

// Filter configuration parameters
// x - screen width
// y - screen height
// z - lens distortion
float3 Settings;

struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 uv		: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 pos		: POSITION;
	float2 uv		: TEXCOORD0;
	float2 coords	: TEXCOORD1;
};

// Vertex Shader
VS_OUTPUT gphMainVSH( VS_INPUT IN )
{
	VS_OUTPUT OUT;

	OUT.pos = mul(float4(IN.pos.xyz,1.0),gphPVMMatrix);

	OUT.uv = IN.uv;
	OUT.coords = IN.pos.xy;
	return OUT;
}

// Pixel Shader
float4 gphMainPSH(VS_OUTPUT IN):COLOR
{
	float2 weight = IN.coords.xy/Settings.xy;
	weight = 1-pow(abs(1-weight*2),2);
	float2 off = normalize(Settings.xy/2.0-IN.coords)*Settings.z;
	float4 tex = tex2D(gphTexture0,IN.uv+off*(1-weight.y* weight.x));
	return tex;
}
