
float4   g_vLightPos[4] = { float4(  3.5f, 1.0f,  5.5f, 1.0f ),
                            float4( -3.5f, 1.0f, -5.5f, 1.0f ),
                            float4(  3.5f, 1.0f, -5.5f, 1.0f ),
                            float4( -3.5f, 1.0f,  5.5f, 1.0f ) };  // Light position in 
float4   g_vLightColor = float4( 0.5f, 0.5f, 0.5f, 1.0f );

float4   g_matDiffuse;              // Diffuse component of material
float4   g_matSpecular;             // Specular component of material
float    g_matPower;                // Specular power of material

texture base;

texture PostEfek;
texture noise;
texture Zoom;

sampler postTex = sampler_state
{
texture = <PostEfek>;
MinFilter = Linear;
MagFilter = Linear;
MipFilter = Linear;
AddressU = Clamp;
AddressV = Clamp;
};
sampler ATex = sampler_state
{
texture = <noise>;
MinFilter = Linear;
MagFilter = Linear;
MipFilter = Linear;
AddressU = wrap;
AddressV = wrap;
};

sampler  g_DiffuseSampler		=	sampler_state
{	
	Texture   = (base);
	
  	AddressU  = WRAP;
  	AddressV  = WRAP;			

	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
};

sampler CTex = sampler_state
{
texture = <Zoom>;
MinFilter = Linear;
MagFilter = Linear;
MipFilter = Linear;
AddressU = wrap;
AddressV = wrap;
};

float vecTime;
float NOISE_MAP=1;
float Isik_Degeri=0.30f;
float4 Zoom_Noise_PS(float2 Tex: TEXCOORD0,float2 Tex2: TEXCOORD1,float2 Tex3: TEXCOORD3) : COLOR
{

float4 Color=float4(1,1,1,1);


float4 baseText = tex2D( postTex, Tex);


float4 LEfek= tex2D( postTex, Tex)+0.51 *Isik_Degeri*cos(vecTime)+0.5;


float4 NOISE = tex2D(ATex, float3(1.05 * Tex*NOISE_MAP+cos(vecTime)*60,1))
+0.5*tex2D(ATex, float3(1.05 * Tex*NOISE_MAP-sin(vecTime)*60, 1))+0.1;




float4 ZOOM=tex2D(CTex,Tex);

baseText.r=0;
baseText.b=0;
Color*=baseText;
Color*=NOISE;
Color*=LEfek;
Color*=ZOOM;

return Color*3;
}

float4 DefaultPS(float2 Tex: TEXCOORD0,float2 Tex2: TEXCOORD1,float2 Tex3: TEXCOORD3) : COLOR
{
float4 Color=float4(1,1,1,1);
Color = tex2D( postTex, Tex);
return Color*1.5;
}



float4 ZoomPS(float2 Tex: TEXCOORD0,float2 Tex2: TEXCOORD1,float2 Tex3: TEXCOORD3) : COLOR
{

float4 Color=float4(1,1,1,1);


float4 baseText = tex2D( postTex, Tex);




float4 ZOOM=tex2D(CTex,Tex);

Color*=baseText;
Color*=ZOOM;

return Color*2;
}


technique tech_00
{
pass p0
{
PixelShader = compile ps_2_0 Zoom_Noise_PS();
}
}

technique tech_01
{
pass p0
{
PixelShader = compile ps_2_0 DefaultPS();
}
}

technique tech_02
{
pass p0
{
PixelShader = compile ps_2_0 ZoomPS();
}
}


             


