/*****************************************************************************/
/*                                                                           */
/*   bkenwright@xbdev.net                                                    */
/*   www.xbdev.net                                                           */
/*                                                                           */
/*****************************************************************************/
/*

   
*/
/*****************************************************************************/


//float4 vecLightDir = float4( 0.0f, 0.0f, 1.0f, 0.0f );

float t_lerp = 0.0f;
float ISIK;

//---------------------------------------------------------------------------//

texture ColourTexture
< 
    string TextureType = "2D";
>;

sampler TextureSampler = sampler_state 
{
    texture = <ColourTexture>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = NONE;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

//---------------------------------------------------------------------------//

// transformations
float4x4 worldViewProj : WORLDVIEWPROJ;

float4x4 matWorldI : WORLD;

//------------------------------------
struct vertexInput {
    float3 position				: POSITION;
    float3 pos2					: PSIZE;
    float2 tex0					: TEXCOORD0;
};

struct vertexOutput {
    float4 position	: POSITION; 
    float4 normal   : TEXCOORD0;   
    float4 colour   : COLOR;
    float2 tex0	    : TEXCOORD1; 
    
};


vertexOutput VS(vertexInput IN) 
{
    vertexOutput OUT = (vertexOutput)0;
    
	float3 p0 = IN.position.xyz;
	float3 p1 = IN.pos2.xyz;

	float3 P = lerp(p0, p1, t_lerp);

/*
lerp 
lerp(a, b, s) Returns a + s(b - a). 
This linearly interpolates between a and b, such that the return value 
is a when s is 0, and b when s is 1. 
*/

	OUT.tex0 = IN.tex0;
	
	//float4 normal = -normalize( mul( matWorldI, IN.normal ).xyzz );
	
	//OUT.colour = Lighting0( colour, normal );
	
	OUT.position = mul(float4(P, 1.0f), worldViewProj);
    return OUT;
}



float4 PS( vertexOutput IN): COLOR
{
	float4 FinalColour = float4(0,0,0,1);


	
	FinalColour = tex2D( TextureSampler,  IN.tex0 );
	
	return FinalColour/ISIK;
}

//---------------------------------------------------------------------------//
technique Effect        
{   
    pass Surface
    {		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS();

    }
    
}// End technique Fur

