uniform sampler2D tex;
uniform sampler2D noise;
uniform vec2 noiseOffset;
uniform float distort;
uniform float coef;

void main()
	{
	vec2 n = vec2( texture2D( noise, vec2( 0.0, gl_TexCoord[0].y + noiseOffset.y ) ).x - 0.5, 0.0 );
	n.x *= distort;
	vec4 col = texture2D( tex, gl_TexCoord[0].xy + n ) * coef;
	col.r = col.r < texture2D( noise, gl_TexCoord[0].xy + noiseOffset ).r ? 0.0 : 1.0;
	col.g = col.g < texture2D( noise, gl_TexCoord[0].xy - noiseOffset ).r ? 0.0 : 1.0;
	col.b = col.b < texture2D( noise, - gl_TexCoord[0].xy + noiseOffset ).r ? 0.0 : 1.0;
	gl_FragColor = col;
	}