## out.vert

void main()
	{
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_FrontColor = gl_Color;
	}

## out.frag

uniform sampler2D tex;
uniform float phase;
uniform float size;

void main()
	{
	vec4 col = texture2D( tex, gl_TexCoord[0].st ) * gl_Color;
	float p = ( gl_TexCoord[0].t + gl_TexCoord[0].s ) * size;
	col.r *= sin( p + phase * 1.1 ) * 0.1 + 1.0;
	col.g *= sin( p + phase * 1.2 ) * 0.1 + 1.0;
	col.b *= sin( p + phase * 1.3 ) * 0.1 + 1.0;
	col.a *= sin( p + phase ) * 0.25 + 1.0;
	gl_FragColor = min( col, 1.0 );	
	}