## build.vert

uniform float foo;
varying float alpha;

vec2 SphereMap( in vec3 ecPos3, in vec3 normal )
	{
	float m;
	vec3 r, u;
	u = normalize( ecPos3 );
	r = reflect( u, normal );
	float z = r.z + 1.0;
	m = 2.0 * sqrt( r.x * r.x + r.y * r.y + z * z );
	return vec2( r.x / m + 0.5, r.y / m + 0.5 );
	}

void main()
	{
	alpha = clamp( 0.5 + 0.5 * sin( ( foo + gl_MultiTexCoord0.x ) * 5.0 ), 0.0, 1.0 );
	
	float l = length( gl_Vertex );
	gl_Vertex.x *= 0.8 + 0.4 * sin( l + foo );	
	gl_Vertex.y *= 0.8 + 0.4 * cos( ( l + foo ) * 1.2 );	
	gl_Vertex.z *= 0.8 + 0.4 * sin( ( l + 1.0 + foo ) * 0.8 );
	
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	
	vec3 ecPos3 = vec3( gl_ModelViewMatrix * gl_Vertex );
	gl_TexCoord[0] = vec4( SphereMap( ecPos3, gl_Normal ), 0, 0 );
	}
	
## buid.frag

uniform sampler2D tex;
uniform float a;
varying float alpha;

void main()
	{
	vec4 col = texture2D( tex, gl_TexCoord[0].st );	
	col.a = alpha * a;
	gl_FragColor = col;
	}
	