uniform sampler2D tex;
uniform sampler2D glowTex;
uniform sampler2D glowMapTex;
uniform sampler2D colorMapTex;
uniform float glowAmount;
uniform float useColorMap;

void main()
	{
	vec2 coord = gl_TexCoord[0].st;
	vec4 col = texture2D( tex, coord );
	col += texture2D( glowTex, coord ) * texture2D( glowMapTex, coord ) * glowAmount;
	if ( useColorMap > 0.0 )
		{
		col *= texture2D( colorMapTex, coord );
		}
	col = clamp( col, 0.0, 1.0 );
	gl_FragColor = col;
	}