## build.vert

uniform float foo;
varying float alpha;

void main()
	{
	alpha = clamp( 0.5 + 0.5 * sin( ( foo + gl_MultiTexCoord0.x ) * 5.0 ), 0.0, 1.0 );
	
	float l = length( gl_Vertex );
	gl_Vertex.x *= 0.8 + 0.4 * sin( l + foo );	
	gl_Vertex.y *= 0.8 + 0.4 * cos( ( l + foo ) * 1.2 );	
	gl_Vertex.z *= 0.8 + 0.4 * sin( ( l + 1.0 + foo ) * 0.8 );
	
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	}

## buid.frag

varying float alpha;
const float g = 0.2;

void main()
	{
	gl_FragColor = vec4( g, g, g, alpha );
	}