## build.vert

uniform float end;
uniform float start;
varying float alpha;

const float range = 0.1;
const float multip = 1.0 / range;

void main()
	{
	float a = end - range;
	float b = end + range;
	
	if ( gl_MultiTexCoord0.x < a )
		{
		alpha = 1.0;
		}
	else if ( gl_MultiTexCoord0.x < b )
		{
		alpha = 1.0 - ( gl_MultiTexCoord0.x - a ) * multip;
		}
	else
		{
		alpha = 0.0;
		}
		
	a = start - range;
	b = start + range;
	
	if ( gl_MultiTexCoord0.x > b )
		{
		}
	else if ( gl_MultiTexCoord0.x > a )
		{
		alpha *= ( gl_MultiTexCoord0.x - a ) * multip;
		}
	else
		{
		alpha = 0.0;
		}

	gl_Position = ftransform();
	}

## buid.frag

varying float alpha;
const float g = 0.05;

void main()
	{
	gl_FragColor = vec4( g, g, g, alpha );
	}