/**************************************************************

ECM-plasma with four different movement/color combinations.
A 512 byte production for Commodore C16/Plus4/116
Coded by Andreas Gustafsson aka. Shadow/Noice in March 2009
andreas.gustafsson@gmail.com
http://ag1976.com

Assemble with Kick Assembler

Memory Map
----------
$1001-$102f Basic
$1030-$11a4 Code
$11a5-$11e8 Charset
$11e9-$1200 Tables
**************************************************************/

.var PLASMA_WIDTH=40
.var PLASMA_HEIGHT=25
.var sinex=$20
.var siney=$b0
.var tmpval=$fe
.var sine1=$2000
.var sine2=$2200
.var sine3=$2400
.var sine4=$2600
.var coltab=$2800
.var chartab=$2900

.var PRECALC_SINE=false

.pc = $1001 "Basic"
.if(PRECALC_SINE)
{
	.byte $0b,$10,$00,$00,$9e,$34,$31,$34,$34,$00,$00,$00
}
else
{
	.byte $2e,$10,$00,$00,$81,$49,$b2,$30
	.byte $a4,$32,$35,$35,$3a,$97,$38,$31
	.byte $39,$32,$aa,$49,$2c,$36,$36,$aa
	.byte $36,$35,$ac,$bf,$28,$49,$ad,$34
	.byte $30,$2e,$37,$29,$3a,$82,$3a,$9e
	.byte $34,$31,$34,$34,$00,$00,$00
}

.pc = $1030 "Code"
		
		sei	
		
		// Setup TED for ECM mode etc.
		lda #$18
		sta $ff13				
		lda #$c0
		sta $ff12			
		lda #$5b
		sta $ff06		
		lda #$00
		sta $ff15
		sta $ff19
		lda #$71
		sta $ff17
			
		// Init the character table	
		ldx #$00
		ldy #$1f
initchartab:	
		txa		
		sta chartab+$00,x
		sta chartab+$e0,y
		ora #$40 // +96
		sta chartab+$20,y
		sta chartab+$40,x
		txa
		ora #$80 // +224
		sta chartab+$60,y
		sta chartab+$80,x
		ora #$40
		sta chartab+$a0,y
		sta chartab+$c0,x
		inx
		dey
		bpl initchartab
		
		// Setup the custom charset
		ldy #$20
outerloop:		
		ldx #$03
innerloop:		
upper:
		lda chars,x
dest1:		
		sta $1800,x
lower:		
		lda chars,x
dest2:		
		sta $1804,x		
		dex
		bpl innerloop
		lda dest1+1
		adc #$08
		sta dest1+1
		adc #$04
		sta dest2+1		
		tya
		and #$01
		bne inclower
		lda upper+1
		adc #$04
		sta upper+1
		bvc !skip+
inclower:
		lda lower+1
		adc #$04
		sta lower+1
!skip:		
		dey
		bne outerloop			
						
		// Setup some sine tables
		ldx #$00
sineloop:		
		txa		
		asl
		tay
		lda sine1,x
		sta sine1+$100,x
		lda sine1,y		
		sta sine2,x
		sta sine2+$100,x
		adc sine1,x
		sta sine3,x
		sta sine3+$100,x
		adc sine1,y
		sta sine4,x
		sta sine4+$100,x
		dex
		bne sineloop		

		// Main 
mainloop:	
		inc framel
		lda framel
		bne nochange
		// Time to bring in a new move/color scheme
		inc frameh
		lda frameh
		and #$03
		tay
		lda sinechoice1,y
		sta sinepos1+2
		lda sinechoice2,y
		sta sinepos2+2
		lda sinechoice3,y
		sta sinepos3+2
		lda sinechoice4,y
		sta sinepos4+2
		ldx #$3f
initloop1:
		lda colors1,y
		ora #$20
		sta coltab+$00,x
		ora #$40
		sta coltab+$40,x
		and #$4f
		sta $ff16
		lda colors2,y
		ora #$40
		sta $ff18
		ora #$20
		sta coltab+$80,x
		and #$3f
		sta coltab+$c0,x
		dex
		bpl initloop1		
nochange:		

		// Update sine tables
		ldx #PLASMA_WIDTH
		ldy #$00
sinepos1:
		lda sine1,y
sinepos2:
		adc sine2,y
		sta sinex,x
sinepos3:
		lda sine3,y
sinepos4:
		adc sine4,y
		sta siney,x
		dey
		dey
		dex		
		bne sinepos1
		inc sinepos1+1		
		dec sinepos2+1
		inc sinepos3+1	
		dec sinepos4+1	
		
		// Render the ECM char plasma
		lda #<[$0800-41]
		sta colpos+1
		sta charpos+1
		lda #>[$0800-41]
		sta colpos+2
		lda #>[$0c00-41]
		sta charpos+2
		lda #PLASMA_HEIGHT+1
		pha		
yloop:		
		pla
		tay
		dey		
		beq done
		tya
		pha
		lda siney,y
		sta tmpval
		clc
		lda colpos+1
		adc #40
		sta colpos+1
		sta charpos+1
		lda colpos+2
		adc #00
		sta colpos+2
		adc #04
		sta charpos+2
	 	ldx #PLASMA_WIDTH 	
xloop: 	
	 	lda sinex,x
	 	adc tmpval
	 	tay
		lda coltab,y
colpos:
	   sta $0800,x
	   lda chartab,y
charpos:   
		sta $0c00,x	
		dex
		bne xloop
		jmp yloop
done:	
		jmp mainloop

.pc = * "Charset"

chars:
.byte %10000000,%00000000,%00000000,%00000000
.byte %10001000,%00000000,%00100000,%00000000
.byte %10001000,%00000000,%10100010,%00000000
.byte %10101000,%00000000,%10101010,%00000000
.byte %10101010,%01000000,%10101010,%00000000
.byte %10101010,%01000100,%10101010,%00010000
.byte %10101010,%01000100,%10101010,%01010001
.byte %10101010,%01010100,%10101010,%01010101
.byte %10101010,%11010101,%10101010,%01010101
.byte %10101010,%11011101,%10101010,%01110101
.byte %10101010,%11011101,%10101010,%11110111
.byte %10101010,%11111101,%10101010,%11111111
.byte %11101010,%11111111,%10101010,%11111111
.byte %11101110,%11111111,%10111010,%11111111
.byte %11101110,%11111111,%11111011,%11111111
.byte %11111110,%11111111,%11111111,%11111111
.byte %11111111,%11111111
// Reuse the last two bytes of the charset as framecounter
framel:
.byte %11111111
frameh: 
.byte %11111111

.pc = * "Tables"
colors1:
	.byte $06,$02,$05,$08
colors2: 
	.byte $0d,$0b,$0f,$09
sinechoice1:
	.byte $20,$26,$20,$24
sinechoice2:
	.byte $22,$24,$20,$26
sinechoice3:
	.byte $24,$22,$22,$22
sinechoice4:
	.byte $26,$24,$22,$20

.if(PRECALC_SINE)
{
	.pc=$2000 "Sine"
	.fill 256,66+66*sin(i/40.7)
}