## sphere.vert

uniform float anim;
uniform float alpha;
uniform float distortAmount;
varying vec4 LightColor;

void main()
	{
	vec4 v = gl_Vertex;
	if ( distortAmount > 0.0 )
		{
		float a = anim + 0.1 * ( v.x + v.y + v.z );
		v *= 1.0 + distortAmount * sin( a );
		}
	gl_Position = gl_ModelViewProjectionMatrix * v;
	
	vec3 ecPos = vec3( gl_ModelViewMatrix * gl_Vertex );
	vec3 viewVec = normalize( -ecPos );
	vec3 tnorm = normalize( gl_NormalMatrix * gl_Normal );
	float r = max( 1.0 - abs( dot( viewVec, tnorm ) ), 0.0 );
	LightColor = vec4( r, 0, 0, alpha );
	}

## sphere.frag

varying vec4 LightColor;

void main()
	{
	gl_FragColor = LightColor;
	}